"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssigneesSelectable = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _userProfileComponents = require("@kbn/user-profile-components");
var _lodash = require("lodash");
var _use_get_current_user_profile = require("../user_profiles/use_get_current_user_profile");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("./constants");
var _use_suggest_users = require("../user_profiles/use_suggest_users");
var _use_bulk_get_user_profiles = require("../user_profiles/use_bulk_get_user_profiles");
var _utils = require("./utils");
var _test_ids = require("./test_ids");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/assignees/assignees_selectable.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * Renders a selectable component given a list of assignees ids
 */
const AssigneesSelectable = exports.AssigneesSelectable = /*#__PURE__*/(0, _react.memo)(({
  searchInputId,
  assignedUserIds,
  showUnassignedOption,
  onSelectionChange
}) => {
  const {
    data: currentUserProfile
  } = (0, _use_get_current_user_profile.useGetCurrentUserProfile)();
  const existingIds = (0, _react.useMemo)(() => new Set((0, _utils.removeNoAssigneesSelection)(assignedUserIds)), [assignedUserIds]);
  const {
    isLoading: isLoadingUserProfiles,
    data: assignedUserProfiles
  } = (0, _use_bulk_get_user_profiles.useBulkGetUserProfiles)({
    uids: existingIds
  });
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const {
    isLoading: isLoadingSuggestedUsers,
    data: userProfiles
  } = (0, _use_suggest_users.useSuggestUsers)({
    searchTerm
  });
  const searchResultProfiles = (0, _react.useMemo)(() => {
    var _bringCurrentUserToFr;
    const sortedUsers = (_bringCurrentUserToFr = (0, _utils.bringCurrentUserToFrontAndSort)(currentUserProfile, userProfiles)) !== null && _bringCurrentUserToFr !== void 0 ? _bringCurrentUserToFr : [];
    if (showUnassignedOption && (0, _lodash.isEmpty)(searchTerm)) {
      return [_constants.NO_ASSIGNEES_VALUE, ...sortedUsers];
    }
    return sortedUsers;
  }, [currentUserProfile, searchTerm, showUnassignedOption, userProfiles]);

  /**
   * Holds user profiles of currently selected users
   */
  const [selectedUserProfiles, setSelectedUserProfiles] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    if (isLoadingUserProfiles || !assignedUserProfiles) {
      return;
    }
    const hasNoAssigneesSelection = assignedUserIds.find(uid => uid === _constants.NO_ASSIGNEES_VALUE);
    const newAssignees = hasNoAssigneesSelection !== undefined ? [_constants.NO_ASSIGNEES_VALUE, ...assignedUserProfiles] : assignedUserProfiles;
    setSelectedUserProfiles(newAssignees);
  }, [assignedUserIds, assignedUserProfiles, isLoadingUserProfiles]);
  const handleSelectedAssignees = (0, _react.useCallback)(newAssignees => {
    if (!(0, _fp.isEqual)(newAssignees, selectedUserProfiles)) {
      setSelectedUserProfiles(newAssignees);
      onSelectionChange === null || onSelectionChange === void 0 ? void 0 : onSelectionChange(newAssignees.map(assignee => {
        var _assignee$uid;
        return (_assignee$uid = assignee === null || assignee === void 0 ? void 0 : assignee.uid) !== null && _assignee$uid !== void 0 ? _assignee$uid : _constants.NO_ASSIGNEES_VALUE;
      }));
    }
  }, [onSelectionChange, selectedUserProfiles]);
  const selectedStatusMessage = (0, _react.useCallback)(total => i18n.ASSIGNEES_SELECTION_STATUS_MESSAGE(total), []);
  const isLoading = isLoadingUserProfiles || isLoadingSuggestedUsers;
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.ASSIGNEES_SELECTABLE_TEST_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_userProfileComponents.UserProfilesSelectable, {
    searchInputId: searchInputId,
    onSearchChange: term => {
      setSearchTerm(term);
    },
    onChange: handleSelectedAssignees,
    selectedStatusMessage: selectedStatusMessage,
    options: searchResultProfiles,
    selectedOptions: selectedUserProfiles,
    isLoading: isLoading,
    height: 'full',
    singleSelection: false,
    searchPlaceholder: i18n.ASSIGNEES_SEARCH_USERS,
    clearButtonLabel: i18n.ASSIGNEES_CLEAR_FILTERS,
    nullOptionLabel: i18n.ASSIGNEES_NO_ASSIGNEES,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }));
});
AssigneesSelectable.displayName = 'AssigneesSelectable';