"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiSelectPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/alert_count_by_status/components/multiselect_popover/multiselect_popover.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MultiSelectPopover = exports.MultiSelectPopover = /*#__PURE__*/_react.default.memo(({
  allItems,
  selectedItems,
  title,
  onSelectedItemsChange
}) => {
  const [isItemPopoverOpen, setIsItemPopoverOpen] = (0, _react.useState)(false);
  const onChange = (0, _react.useCallback)(item => onSelectedItemsChange(getUpdatedSelectedItems(item, selectedItems)), [selectedItems, onSelectedItemsChange]);
  const itemList = (0, _react.useMemo)(() => {
    return allItems.map((item, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
      checked: selectedItems.includes(item) ? 'on' : undefined,
      key: `${index}-${item}`,
      onClick: () => onChange(item),
      title: item,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }, item));
  }, [allItems, selectedItems, onChange]);
  const togglePopover = (0, _react.useCallback)(toState => {
    setIsItemPopoverOpen(s => toState ? toState : !s);
  }, [setIsItemPopoverOpen]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      grow: false,
      "data-test-subj": 'multiselect-popover-button',
      iconType: "arrowDown",
      onClick: () => togglePopover(),
      numFilters: allItems.length,
      isSelected: isItemPopoverOpen,
      hasActiveFilters: selectedItems.length > 0,
      numActiveFilters: selectedItems.length,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 13
      }
    }, title)),
    isOpen: isItemPopoverOpen,
    closePopover: () => togglePopover(false),
    panelPaddingSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }, itemList);
});
MultiSelectPopover.displayName = 'MultiSelectPopover';
const getUpdatedSelectedItems = (item, selectedItems) => {
  const selectedGroupIndex = selectedItems.indexOf(item);
  const updatedSelectedItems = [...selectedItems];
  if (selectedGroupIndex >= 0) {
    updatedSelectedItems.splice(selectedGroupIndex, 1);
  } else {
    updatedSelectedItems.push(item);
  }
  return updatedSelectedItems;
};