"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Filters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/unified-search-plugin/public");
var _use_data_view = require("../../../../../../data_view_manager/hooks/use_data_view");
var _model = require("../../../../../../sourcerer/store/model");
var _containers = require("../../../../../../sourcerer/containers");
var _use_create_data_view = require("../../../../../../common/hooks/use_create_data_view");
var _use_experimental_features = require("../../../../../../common/hooks/use_experimental_features");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/settings_flyout/schedule/details_flyout/definition/filters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Filters = exports.Filters = /*#__PURE__*/_react.default.memo(({
  filters
}) => {
  const newDataViewPickerEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('newDataViewPickerEnabled');
  const {
    dataView: experimentalDataView
  } = (0, _use_data_view.useDataView)(_model.SourcererScopeName.detections);

  // get the sourcerer `DataViewSpec` for alerts:
  const {
    sourcererDataView: oldSourcererDataView,
    loading: oldIsLoadingIndexPattern
  } = (0, _containers.useSourcererDataView)(_model.SourcererScopeName.detections);

  // create a `DataView` from the `DataViewSpec`:
  const {
    dataView: oldDataView
  } = (0, _use_create_data_view.useCreateDataView)({
    dataViewSpec: oldSourcererDataView,
    loading: oldIsLoadingIndexPattern,
    skip: newDataViewPickerEnabled
  });
  const alertsDataView = newDataViewPickerEnabled ? experimentalDataView : oldDataView;
  const isEsql = filters.some(filter => {
    var _filter$query;
    return (filter === null || filter === void 0 ? void 0 : (_filter$query = filter.query) === null || _filter$query === void 0 ? void 0 : _filter$query.language) === 'esql';
  });
  const searchBarFilters = (0, _react.useMemo)(() => {
    if (!alertsDataView || isEsql) {
      return filters;
    }
    const index = alertsDataView.getIndexPattern();
    const filtersWithUpdatedMetaIndex = filters.map(filter => {
      return {
        ...filter,
        meta: {
          ...filter.meta,
          index
        }
      };
    });
    return filtersWithUpdatedMetaIndex;
  }, [alertsDataView, filters, isEsql]);
  if (!alertsDataView) {
    return null;
  }
  const flattenedFilters = (0, _public.mapAndFlattenFilters)(searchBarFilters);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": 'filters',
    wrap: true,
    responsive: false,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.FilterItems, {
    filters: flattenedFilters,
    indexPatterns: [alertsDataView],
    readOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }));
});
Filters.displayName = 'Filters';