"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Editor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _monaco = require("@kbn/monaco");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/searchprofiler/public/application/components/profile_query_editor/editor/editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EDITOR_INPUT_ID = 'SearchProfilerTextArea';
const Editor = exports.Editor = /*#__PURE__*/(0, _react.memo)(({
  licenseEnabled,
  editorValue,
  setEditorValue,
  onEditorReady
}) => {
  const editorDidMountCallback = (0, _react.useCallback)(editor => {
    onEditorReady({
      focus: () => {
        editor.focus();
      }
    });
  }, [onEditorReady]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: EDITOR_INPUT_ID,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchProfiler.editorElementLabel', {
    defaultMessage: 'Dev Tools Search Profiler editor'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    languageId: _monaco.XJsonLang.ID,
    dataTestSubj: "searchProfilerEditor",
    value: editorValue,
    editorDidMount: editorDidMountCallback,
    options: {
      readOnly: !licenseEnabled,
      lineNumbers: 'on',
      tabSize: 2,
      automaticLayout: true,
      overviewRulerLanes: 0
    },
    "aria-label": _i18n.i18n.translate('xpack.searchProfiler.editor.queryEditor', {
      defaultMessage: 'Query editor'
    }),
    onChange: setEditorValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }));
});