"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryRuleFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _i18nReact = require("@kbn/i18n-react");
var _reactHookForm = require("react-hook-form");
var _field_error_utils = require("../../../utils/field_error_utils");
var _use_kibana = require("../../../hooks/use_kibana");
var _styles = require("../styles");
var _query_rule_metadata_editor = require("./query_rule_metadata_editor");
var _use_query_rule_flyout_state = require("./use_query_rule_flyout_state");
var _query_rule_flyout_header = require("./query_rule_flyout_header");
var _rule_type_selector = require("./document_selector/rule_type_selector");
var _pin_exclude_document_button = require("./pin_exclude_document_button");
var _metadata_type_selector = require("./metadata_type_selector");
var _draggable_list = require("./document_selector/draggable_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_query_rules/public/components/query_ruleset_detail/query_rule_flyout/query_rule_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const QueryRuleFlyout = ({
  rules,
  onClose,
  onSave,
  ruleId,
  rulesetId,
  setIsFormDirty,
  createMode = false
}) => {
  const {
    actionFields,
    actionIdsFields,
    appendAction: appendNewAction,
    control,
    criteria,
    criteriaCount,
    documentCount,
    dragEndHandle,
    formState,
    handleAddCriteria,
    handleSave,
    indexNames,
    isFlyoutDirty,
    isIdRule,
    onDeleteDocument,
    onIdSelectorChange,
    onIndexSelectorChange,
    pinType,
    remove,
    setCriteriaCalloutActive,
    shouldShowCriteriaCallout,
    shouldShowMetadataEditor,
    update
  } = (0, _use_query_rule_flyout_state.useQueryRuleFlyoutState)({
    createMode,
    rulesetId,
    ruleId,
    rules,
    setIsFormDirty,
    onSave
  });
  const {
    services: {
      application
    }
  } = (0, _use_kibana.useKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const dndBackgroundColor = (0, _react2.css)`
    background-color: ${euiTheme.colors.backgroundBaseFormsPrepend};
  `;
  const pinExcludeText = pinType === 'pinned' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.actionType.pinned.description",
    defaultMessage: "Pin documents to the top of the search results.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.actionType.exclude.description",
    defaultMessage: "Exclude documents from the search results.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    ownFocus: false,
    size: "l",
    "data-test-subj": "searchQueryRulesQueryRuleFlyout",
    "aria-labelledby": "flyoutTitle",
    css: (0, _react2.css)({
      overflowY: 'hidden'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_query_rule_flyout_header.QueryRuleFlyoutHeader, {
    ruleId: ruleId,
    createMode: createMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    css: _styles.QueryRuleFlyoutBody,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    css: _styles.QueryRuleFlyoutPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "l",
    borderRadius: "none",
    className: "eui-yScroll",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.actionTypeHeading",
    defaultMessage: "I want to",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "type",
    render: ({
      field: {
        value,
        onChange
      }
    }) => /*#__PURE__*/_react.default.createElement(_rule_type_selector.QueryRuleTypeSelector, {
      onChange: onChange,
      selectedId: value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 23
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 21
    }
  }, pinExcludeText)))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.documentCount",
    defaultMessage: "{documentCount, plural, one {# document} other {# documents}}",
    values: {
      documentCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.findDocuments",
    defaultMessage: "Find your documents IDs into ",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "searchQueryRulesQueryRuleFlyoutLink",
    external: true,
    href: "#" // Removing href hides the external link icon
    ,
    onClick: e => {
      e.preventDefault();
      application.navigateToApp(_deeplinksAnalytics.DISCOVER_APP_ID, {
        openInNewTab: true
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.DiscoverDocumentsLink",
    defaultMessage: "Discover",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 15
    }
  }), isIdRule && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: "Document action using 'ids' are unsupported",
    color: "warning",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRuleset.queryRuleFlyout.idsActionDeprecation",
    defaultMessage: "Query rules pinning/excluding documents using ids only are not supported in the UIs. Please convert them to pinning by docs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 25
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: dndBackgroundColor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_draggable_list.DraggableList, {
    onIndexSelectorChange: onIndexSelectorChange,
    onIdSelectorChange: onIdSelectorChange,
    actionFields: actionFields,
    actionIdsFields: actionIdsFields,
    isIdRule: isIdRule,
    pinType: pinType,
    indexNames: indexNames,
    dragEndHandle: dragEndHandle,
    onDeleteDocument: onDeleteDocument,
    errors: formState.errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 17
    }
  })), pinType === 'pinned' && documentCount !== 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "transitionTopIn",
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.queryRuleFlyout.organicResultsCallout",
      defaultMessage: "All other organic results will be displayed below",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_pin_exclude_document_button.ExcludePinDocumentButton, {
    documentCount: documentCount,
    addNewAction: appendNewAction,
    pinType: pinType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    css: _styles.QueryRuleFlyoutPanel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    paddingSize: "l",
    borderRadius: "none",
    className: "eui-yScroll",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.criteriaHeading",
    defaultMessage: "Criteria",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "isAlways",
    render: ({
      field: {
        value,
        onChange
      }
    }) => /*#__PURE__*/_react.default.createElement(_metadata_type_selector.MetadataTypeSelector, {
      isAlways: value,
      onChange: onChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 23
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 285,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.criteria.custom.description",
    defaultMessage: "Define the conditions that trigger this rule.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 23
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 15
    }
  }), shouldShowCriteriaCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "info",
    size: "s",
    onDismiss: () => {
      setCriteriaCalloutActive(false);
    },
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.queryRuleFlyout.allCriteriaCallout",
      defaultMessage: "All criteria must be met for the rule to be applied",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 23
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 19
    }
  })), shouldShowMetadataEditor && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, criteria.length ? criteria.map((field, index) => {
    var _formState$errors, _formState$errors$cri;
    const error = (_formState$errors = formState.errors) === null || _formState$errors === void 0 ? void 0 : (_formState$errors$cri = _formState$errors.criteria) === null || _formState$errors$cri === void 0 ? void 0 : _formState$errors$cri[index];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
      key: field.id,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 322,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_query_rule_metadata_editor.QueryRuleMetadataEditor, {
      criteria: field,
      key: field.id,
      onChange: newCriteria => {
        update(index, newCriteria);
      },
      onRemove: () => {
        remove(index);
      },
      error: (0, _field_error_utils.isQueryRuleFieldError)(error) ? error : undefined,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 323,
        columnNumber: 27
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 27
      }
    }));
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    iconType: "info",
    size: "s",
    color: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.search.queryRulesetDetail.queryRuleFlyout.criteriaRequiredCallout",
      defaultMessage: "At least one criteria is required.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 346,
        columnNumber: 27
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 340,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 352,
      columnNumber: 23
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchQueryRulesQueryRuleMetadataEditorAddCriteriaButton",
    onClick: handleAddCriteria,
    iconType: "plusInCircle",
    iconSide: "left",
    size: "s",
    color: criteriaCount === 0 ? 'primary' : 'text',
    fill: criteriaCount === 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 356,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.addCriteriaButton",
    defaultMessage: "AND",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 21
    }
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 378,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "searchQueryRulesQueryRuleFlyoutCancelButton",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.closeButton",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 383,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "searchQueryRulesQueryRuleFlyoutUpdateButton",
    fill: true,
    onClick: handleSave,
    disabled:
    // Id rule is not supported in the UI. We still allow saving it.
    // To make it properly, we need to reimplement the action logic in RHF
    !isIdRule && !isFlyoutDirty || !formState.isValid || formState.isSubmitting || formState.isValidating,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 13
    }
  }, createMode ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.createButton",
    defaultMessage: "Create rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 404,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.search.queryRulesetDetail.queryRuleFlyout.updateButton",
    defaultMessage: "Update rule",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 409,
      columnNumber: 17
    }
  }))))));
};
exports.QueryRuleFlyout = QueryRuleFlyout;