"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaygroundName = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_playground/public/components/saved_playground/playground_name.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EDIT_NAME_LABEL = _i18n.i18n.translate('xpack.searchPlayground.savedPlayground.editPlaygroundName.ariaLabel', {
  defaultMessage: 'Edit playground name'
});
const PlaygroundName = ({
  playgroundName,
  onEditName
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    css: (0, _react2.css)({
      whiteSpace: 'nowrap'
    }),
    "data-test-subj": "playgroundName",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 25,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }, playgroundName, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": EDIT_NAME_LABEL,
    color: "text",
    "data-test-subj": "edit-playground-name-button",
    display: "empty",
    iconType: "pencil",
    size: "s",
    onClick: onEditName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  })));
};
exports.PlaygroundName = PlaygroundName;