"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleDataIngestPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _installation = require("./services/installation");
var _utils = require("./services/utils");
var _common = require("../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class SampleDataIngestPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.logger = context.logger.get();
  }
  setup() {
    return {};
  }
  start(coreStart) {
    const installationService = new _installation.InstallationService({
      http: coreStart.http
    });
    return {
      getStatus: () => installationService.getInstallationStatus(),
      install: () => installationService.install(),
      isSampleIndex: _utils.isSampleIndex,
      minimumLicenseType: _common.MINIMUM_LICENSE_TYPE
    };
  }
}
exports.SampleDataIngestPlugin = SampleDataIngestPlugin;