"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FramesSummary = FramesSummary;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _as_cost = require("../../utils/formatters/as_cost");
var _as_weight = require("../../utils/formatters/as_weight");
var _utils = require("../topn_functions/utils");
var _summary_item = require("./summary_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/frames_summary/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ESTIMATED_VALUE_LABEL = _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.estimatedValue', {
  defaultMessage: 'Estimated value'
});
function FramesSummary({
  baseValue,
  comparisonValue,
  isLoading,
  hasBorder = false,
  compressed = false
}) {
  const baselineScaledTotalSamples = baseValue ? (0, _utils.scaleAndRoundValue)({
    value: baseValue.totalCount,
    scaleFactor: baseValue.scaleFactor
  }) : 0;
  const comparisonScaledTotalSamples = comparisonValue ? (0, _utils.scaleAndRoundValue)({
    value: comparisonValue.totalCount,
    scaleFactor: comparisonValue.scaleFactor
  }) : 0;
  const {
    co2EmissionDiff,
    costImpactDiff,
    totalSamplesDiff
  } = (0, _react.useMemo)(() => {
    return {
      totalSamplesDiff: (0, _utils.calculateBaseComparisonDiff)({
        baselineValue: baselineScaledTotalSamples || 0,
        comparisonValue: comparisonScaledTotalSamples || 0
      }),
      co2EmissionDiff: (0, _utils.calculateBaseComparisonDiff)({
        baselineValue: (baseValue === null || baseValue === void 0 ? void 0 : baseValue.totalAnnualCO2Kgs) || 0,
        comparisonValue: (comparisonValue === null || comparisonValue === void 0 ? void 0 : comparisonValue.totalAnnualCO2Kgs) || 0,
        formatValue: value => (0, _as_weight.asWeight)(value, 'kgs')
      }),
      costImpactDiff: (0, _utils.calculateBaseComparisonDiff)({
        baselineValue: (baseValue === null || baseValue === void 0 ? void 0 : baseValue.totalAnnualCostUSD) || 0,
        comparisonValue: (comparisonValue === null || comparisonValue === void 0 ? void 0 : comparisonValue.totalAnnualCostUSD) || 0,
        formatValue: _as_cost.asCost
      })
    };
  }, [baseValue, baselineScaledTotalSamples, comparisonScaledTotalSamples, comparisonValue]);
  const data = [{
    id: 'overallPerformance',
    title: _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.summary.performance', {
      defaultMessage: '{label} overall performance by',
      values: {
        label: isLoading || totalSamplesDiff.percentDiffDelta === undefined || totalSamplesDiff.label === undefined ? 'Gained/Lost' : (totalSamplesDiff === null || totalSamplesDiff === void 0 ? void 0 : totalSamplesDiff.percentDiffDelta) > 0 ? 'Lost' : 'Gained'
      }
    }),
    baseValue: totalSamplesDiff.label || '0%',
    baseColor: totalSamplesDiff.color,
    titleHint: ESTIMATED_VALUE_LABEL,
    hidden: (0, _lodash.isEmpty)(comparisonValue)
  }, {
    id: 'annualizedCo2',
    title: _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.summary.co2', {
      defaultMessage: 'Annualized CO2 emission impact'
    }),
    baseValue: co2EmissionDiff.baseValue,
    comparisonValue: co2EmissionDiff.comparisonValue,
    comparisonColor: co2EmissionDiff.color,
    comparisonPerc: co2EmissionDiff.label,
    titleHint: ESTIMATED_VALUE_LABEL
  }, {
    id: 'annualizedCost',
    title: _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.summary.cost', {
      defaultMessage: 'Annualized cost impact'
    }),
    baseValue: costImpactDiff.baseValue,
    comparisonValue: costImpactDiff.comparisonValue,
    comparisonColor: costImpactDiff.color,
    comparisonPerc: costImpactDiff.label,
    titleHint: ESTIMATED_VALUE_LABEL
  }, {
    id: 'totalNumberOfSamples',
    title: _i18n.i18n.translate('xpack.profiling.diffTopNFunctions.summary.samples', {
      defaultMessage: 'Total number of samples'
    }),
    baseValue: totalSamplesDiff.baseValue,
    comparisonValue: totalSamplesDiff.comparisonValue,
    comparisonColor: totalSamplesDiff.color,
    comparisonPerc: totalSamplesDiff.label,
    titleHint: ESTIMATED_VALUE_LABEL
  }];
  const Summary = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, data.filter(item => !item.hidden).map(item => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: item.id,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_summary_item.SummaryItem, (0, _extends2.default)({}, item, {
      isLoading: isLoading,
      hasBorder: hasBorder,
      compressed: compressed,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 17
      }
    })));
  })));
  return compressed ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, Summary) : /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    initialIsOpen: true,
    id: "TopNFunctionsSummary",
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: data[0].baseColor,
      style: {
        fontWeight: 'bold'
      },
      textAlign: "left",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 13
      }
    }, data[0].title)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 171,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      style: {
        fontWeight: 'bold'
      },
      color: data[0].baseColor,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 13
      }
    }, data[0].baseValue))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 5
    }
  }, Summary);
}