"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShardsPolicyField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _agent_policies = require("../../../agent_policies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/packs/form/shards/shards_policy_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ShardsPolicyFieldComponent = ({
  index,
  control,
  hideLabel,
  options
}) => {
  const {
    data: {
      agentPoliciesById
    } = {}
  } = (0, _agent_policies.useAgentPolicies)();
  const missingValueError = _i18n.i18n.translate('xpack.osquery.pack.form.shardsPolicyFieldMissingErrorMessage', {
    defaultMessage: 'Policy is a required field'
  });
  const policyFieldValidator = (0, _react.useCallback)(policy => !policy ? missingValueError : undefined, [missingValueError]);
  const {
    field: {
      onChange,
      value
    },
    fieldState: {
      error
    }
  } = (0, _reactHookForm.useController)({
    control,
    name: `shardsArray.${index}.policy`,
    rules: {
      validate: policyFieldValidator,
      required: missingValueError
    }
  });
  const hasError = (0, _react.useMemo)(() => !!(error !== null && error !== void 0 && error.message), [error === null || error === void 0 ? void 0 : error.message]);
  const [selectedOptions, setSelected] = (0, _react.useState)([]);
  const handleChange = (0, _react.useCallback)(newSelectedOptions => {
    setSelected(newSelectedOptions);
    onChange(newSelectedOptions[0]);
  }, [onChange]);
  (0, _react.useEffect)(() => {
    const foundPolicy = agentPoliciesById === null || agentPoliciesById === void 0 ? void 0 : agentPoliciesById[value.key];
    if (value && foundPolicy) {
      setSelected([{
        label: value.label || foundPolicy.name,
        value: value.key
      }]);
    }
  }, [agentPoliciesById, value]);
  const singleSelectionConfig = (0, _react.useMemo)(() => ({
    asPlainText: true
  }), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: hideLabel ? '' : _i18n.i18n.translate('xpack.osquery.pack.form.policyFieldLabel', {
      defaultMessage: 'Policy'
    }),
    error: error === null || error === void 0 ? void 0 : error.message,
    isInvalid: hasError,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: singleSelectionConfig,
    isInvalid: hasError,
    options: options,
    selectedOptions: selectedOptions,
    onChange: handleChange,
    "data-test-subj": "shards-field-policy",
    rowHeight: 32,
    isClearable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }));
};
const ShardsPolicyField = exports.ShardsPolicyField = /*#__PURE__*/_react.default.memo(ShardsPolicyFieldComponent);