"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EsqlEditorField = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _public = require("@kbn/esql/public");
var _lodash = require("lodash");
var _react2 = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
var _util = require("util");
var _use_esql_params_validation = require("../../hooks/use_esql_params_validation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/components/esql/esql_editor_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EsqlEditorField = exports.EsqlEditorField = /*#__PURE__*/_react2.default.memo(() => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    control,
    formState,
    trigger
  } = (0, _reactHookForm.useFormContext)();
  const {
    isSubmitted
  } = formState;
  const {
    triggerEsqlParamWarnings
  } = (0, _use_esql_params_validation.useEsqlParamsValidation)();
  return /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "esql",
    render: ({
      field: {
        onBlur,
        ...field
      }
    }) => /*#__PURE__*/_react2.default.createElement("div", {
      onBlur: () => {
        if (isSubmitted) {
          trigger('esql');
        } else {
          triggerEsqlParamWarnings();
        }
      },
      css: (0, _react.css)`
            margin-top: -${euiTheme.size.base};
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_public.ESQLLangEditor, {
      query: {
        esql: field.value
      },
      onTextLangQueryChange: query => {
        field.onChange(query.esql);
        if (isSubmitted) {
          triggerEsqlParamWarnings();
        }
      },
      onTextLangQuerySubmit: (0, _util.promisify)(_lodash.noop) // Required prop, but we don't need it
      ,
      editorIsInline: true,
      hideRunQueryText: true,
      hasOutline: true,
      hideRunQueryButton: true,
      hideQueryHistory: true,
      hideTimeFilterInfo: true,
      disableAutoFocus: true,
      initialState: {
        editorHeight: 360
      },
      errors: [] // Hides the initial error message, won't prevent future errors
      ,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 42,
        columnNumber: 11
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  });
});