"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldValueCombobox = FieldValueCombobox;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability_shared/public/components/field_value_suggestions/field_value_combobox.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const formatOptions = (values, allowAllValuesSelection) => {
  const uniqueValues = Array.from(new Set(allowAllValuesSelection && (values !== null && values !== void 0 ? values : []).length > 0 ? ['ALL_VALUES', ...(values !== null && values !== void 0 ? values : [])] : values));
  return (uniqueValues !== null && uniqueValues !== void 0 ? uniqueValues : []).map(label => ({
    label
  }));
};
function FieldValueCombobox({
  label,
  selectedValue,
  loading,
  values,
  setQuery,
  usePrependLabel = true,
  compressed = true,
  required = true,
  singleSelection = false,
  allowAllValuesSelection,
  onChange: onSelectionChange
}) {
  const [options, setOptions] = (0, _react.useState)(() => {
    var _values$map;
    return formatOptions((0, _lodash.union)((_values$map = values === null || values === void 0 ? void 0 : values.map(({
      label: lb
    }) => lb)) !== null && _values$map !== void 0 ? _values$map : [], selectedValue !== null && selectedValue !== void 0 ? selectedValue : []), allowAllValuesSelection);
  });
  (0, _react.useEffect)(() => {
    var _values$map2;
    setOptions(formatOptions((0, _lodash.union)((_values$map2 = values === null || values === void 0 ? void 0 : values.map(({
      label: lb
    }) => lb)) !== null && _values$map2 !== void 0 ? _values$map2 : [], selectedValue !== null && selectedValue !== void 0 ? selectedValue : []), allowAllValuesSelection));
  }, [allowAllValuesSelection, selectedValue, values]);
  const onChange = selectedValuesN => {
    onSelectionChange(selectedValuesN.map(({
      label: lbl
    }) => lbl));
  };
  const searchFieldPlaceholder = _i18n.i18n.translate('xpack.observabilityShared.fieldValueSelection.placeholder.search', {
    defaultMessage: 'Search {label}',
    values: {
      label
    }
  });
  const comboBox = /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    singleSelection: singleSelection ? {
      asPlainText: true
    } : false,
    compressed: compressed,
    placeholder: searchFieldPlaceholder,
    "aria-label": searchFieldPlaceholder,
    isLoading: loading,
    onSearchChange: searchVal => {
      setQuery(searchVal);
    },
    options: options,
    selectedOptions: options.filter(opt => selectedValue === null || selectedValue === void 0 ? void 0 : selectedValue.includes(opt.label)),
    onChange: onChange,
    isInvalid: required && (0, _lodash.isEmpty)(selectedValue),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  });
  return usePrependLabel ? /*#__PURE__*/_react.default.createElement(ComboWrapper, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    fullWidth: true,
    prepend: label,
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, comboBox)) : /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    display: "center",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, comboBox);
}
const ComboWrapper = _styledComponents.default.div`
  &&& {
    .euiFormControlLayout {
      height: auto;
      .euiFormControlLayout__prepend {
        margin: auto;
      }
      .euiComboBoxPill {
        max-width: 250px;
      }
      .euiComboBox__inputWrap {
        border-radius: 0;
      }
    }
  }
`;