"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _unassigned = require("./unassigned");
var _assigned = require("./assigned");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/shard_allocation/components/table_body.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ShardRow = props => {
  let unassigned;
  if (props.data.unassigned && props.data.unassigned.length) {
    unassigned = /*#__PURE__*/_react.default.createElement(_unassigned.Unassigned, {
      shards: props.data.unassigned,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 17,
        columnNumber: 18
      }
    });
  } else {
    if (props.cols === 3) {
      unassigned = /*#__PURE__*/_react.default.createElement("td", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 20,
          columnNumber: 20
        }
      });
    }
  }
  return /*#__PURE__*/_react.default.createElement("tr", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }, unassigned, /*#__PURE__*/_react.default.createElement(_assigned.Assigned, {
    shardStats: props.shardStats,
    data: props.data.children,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 7
    }
  }));
};
class TableBody extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "createRow", (data, index) => {
      return /*#__PURE__*/_react.default.createElement(ShardRow, (0, _extends2.default)({
        key: `shardRow-${index}`,
        data: data
      }, this.props, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 12
        }
      }));
    });
  }
  render() {
    if (this.props.totalCount === 0) {
      return /*#__PURE__*/_react.default.createElement("tbody", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("tr", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("td", {
        colSpan: this.props.cols,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        style: {
          margin: '10px 0'
        },
        className: "text-center lead",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.elasticsearch.shardAllocation.tableBody.noShardsAllocatedDescription",
        defaultMessage: "There are no shards allocated.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 19
        }
      }))))));
    }
    if (this.props.shardStats) {
      if (this.props.rows.length) {
        return /*#__PURE__*/_react.default.createElement("tbody", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 65,
            columnNumber: 16
          }
        }, this.props.rows.map(this.createRow));
      }
    }
    return /*#__PURE__*/_react.default.createElement("tbody", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("tr", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("td", {
      colSpan: this.props.cols,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    })));
  }
}
exports.TableBody = TableBody;
(0, _defineProperty2.default)(TableBody, "displayName", _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.tableBodyDisplayName', {
  defaultMessage: 'TableBody'
}));