"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitoringTimeseriesContainer = MonitoringTimeseriesContainer;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _get_technical_preview = require("./get_technical_preview");
var _get_title = require("./get_title");
var _get_units = require("./get_units");
var _monitoring_timeseries = require("./monitoring_timeseries");
var _info_tooltip = require("./info_tooltip");
var _badge = require("../../alerts/badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/chart/monitoring_timeseries_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const zoomStyle = ({
  euiTheme
}) => (0, _react2.css)`
  visibility: hidden;
  ${(0, _eui.logicalCSS)('padding-right', euiTheme.size.m)}
`;
const wrapperStyle = (0, _react2.css)`
  &:hover .rhythmChart__zoom {
    visibility: visible;
  }
`;
const isSeriesAlert = series => {
  return series.alerts !== undefined;
};
const zoomOutBtn = zoomInfo => {
  if (!zoomInfo || !zoomInfo.showZoomOutBtn()) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "rhythmChart__zoom",
    css: zoomStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "primary",
    size: "s",
    iconType: "magnifyWithMinus",
    onClick: zoomInfo.zoomOutHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.chart.timeSeries.zoomOut",
    defaultMessage: "Zoom out",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 11
    }
  }))));
};
const technicalPreviewBadge = technicalPreview => {
  if (!technicalPreview) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    iconType: "cheer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.chart.timeSeries.technicalPreview",
    defaultMessage: "Technical Preview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  })));
};
function MonitoringTimeseriesContainer({
  series,
  onBrush,
  zoomInfo
}) {
  if (series === undefined) {
    return null; // still loading
  }
  const seriesMetrics = !isSeriesAlert(series) ? series : [];
  const title = (0, _get_title.getTitle)(seriesMetrics);
  const technicalPreview = (0, _get_technical_preview.getTechnicalPreview)(seriesMetrics);
  const titleForAriaIds = title.replace(/\s+/, '--');
  const units = (0, _get_units.getUnits)(seriesMetrics);
  const bucketSize = (0, _lodash.get)((0, _lodash.first)(seriesMetrics), 'bucket_size'); // bucket size will be the same for all metrics in all series

  const seriesScreenReaderTextList = [_i18n.i18n.translate('xpack.monitoring.chart.seriesScreenReaderListDescription', {
    defaultMessage: 'Interval: {bucketSize}',
    values: {
      bucketSize
    }
  })].concat(seriesMetrics.map(item => `${item.metric.label}: ${item.metric.description}`));
  let alertStatus = null;
  const seriesAlert = isSeriesAlert(series) ? series : undefined;
  if (seriesAlert !== null && seriesAlert !== void 0 && seriesAlert.alerts) {
    alertStatus = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_badge.AlertsBadge, {
      alerts: seriesAlert.alerts,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    css: wrapperStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 19
    }
  }, (0, _get_title.getTitle)(seriesMetrics), units ? ` (${units})` : '', /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.chart.screenReaderUnaccessibleTitle",
    defaultMessage: "This chart is not screen reader accessible",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 25
    }
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    anchorClassName: "eui-textRight eui-alignMiddle",
    type: "info",
    position: "right",
    content: /*#__PURE__*/_react.default.createElement(_info_tooltip.InfoTooltip, {
      series: seriesMetrics,
      bucketSize: bucketSize,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 30
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    id: `monitoringChart${titleForAriaIds}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 21
    }
  }, seriesScreenReaderTextList.join('. '))))), technicalPreviewBadge(technicalPreview), zoomOutBtn(zoomInfo))), alertStatus)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minHeight: '200px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_monitoring_timeseries.MonitoringTimeseries, {
    series: seriesMetrics,
    onBrush: onBrush,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 9
    }
  })));
}