"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireWildcard(require("moment"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _common = require("@kbn/data-plugin/common");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _lodash = require("lodash");
var _timeseriesexplorer_embeddable_chart = require("../../application/timeseriesexplorer/timeseriesexplorer_embeddable_chart");
var _timeseriesexplorer_constants = require("../../application/timeseriesexplorer/timeseriesexplorer_constants");
var _styles = require("../../application/timeseriesexplorer/styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/shared_components/single_metric_viewer/single_metric_viewer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const containerPadding = 20;
const minElemAndChartDiff = 20;
const RESIZE_THROTTLE_TIME_MS = 500;
const basicErrorMessage = _i18n.i18n.translate('xpack.ml.singleMetricViewerEmbeddable.errorMessage"', {
  defaultMessage: 'Unable to load the ML single metric viewer data'
});
const jobNotFoundErrorMessage = _i18n.i18n.translate('xpack.ml.singleMetricViewerEmbeddable.jobNotFoundErrorMessage"', {
  defaultMessage: 'No known job with the selected id'
});

/**
 * Only used to initialize internally
 */

const SingleMetricViewerWrapper = ({
  // Component dependencies
  api,
  coreStart,
  pluginStart,
  mlServices,
  // Component props
  bounds,
  functionDescription,
  lastRefresh,
  onError,
  onForecastIdChange,
  onRenderComplete,
  forecastId,
  selectedDetectorIndex,
  selectedEntities,
  selectedJobId,
  shouldShowForecastButton,
  uuid
}) => {
  const timeseriesExplorerStyles = (0, _styles.useTimeseriesExplorerStyles)();
  const annotationStyles = (0, _styles.useAnnotationStyles)();
  const [chartDimensions, setChartDimensions] = (0, _react.useState)({
    width: 0,
    height: 0
  });
  const [zoom, setZoom] = (0, _react.useState)();
  const [selectedForecastId, setSelectedForecastId] = (0, _react.useState)(forecastId);
  const [selectedJobWrapper, setSelectedJobWrapper] = (0, _react.useState)();
  const [errorEncountered, setErrorEncountered] = (0, _react.useState)();
  const isMounted = (0, _useMountedState.default)();
  const {
    mlApi,
    mlTimeSeriesExplorerService,
    toastNotificationService
  } = mlServices;
  const startServices = (0, _lodash.pick)(coreStart, 'analytics', 'i18n', 'theme', 'userProfile');
  const datePickerDeps = {
    ...(0, _lodash.pick)(coreStart, ['http', 'notifications', 'theme', 'uiSettings', 'userProfile', 'i18n']),
    data: pluginStart.data,
    uiSettingsKeys: _common.UI_SETTINGS,
    showFrozenDataTierChoice: false
  };
  const previousRefresh = (0, _usePrevious.default)(lastRefresh !== null && lastRefresh !== void 0 ? lastRefresh : 0);
  (0, _react.useEffect)(function resetErrorOnJobChange() {
    // Calling onError to clear any previous error
    setErrorEncountered(undefined);
    onError === null || onError === void 0 ? void 0 : onError();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [selectedJobId]);
  (0, _react.useEffect)(function setUpSelectedJob() {
    async function fetchSelectedJob() {
      if (mlApi && selectedJobId !== undefined) {
        try {
          const [{
            jobs
          }, {
            jobs: jobStats
          }] = await Promise.all([mlApi.getJobs({
            jobId: selectedJobId
          }), mlApi.getJobStats({
            jobId: selectedJobId
          })]);
          setSelectedJobWrapper({
            job: jobs[0],
            stats: jobStats[0]
          });
        } catch (e) {
          const error = (0, _mlErrorUtils.extractErrorProperties)(e);
          // Could get 404 because job has been deleted and also avoid infinite refetches on any error
          setErrorEncountered(error.statusCode);
          if (onError) {
            onError(new Error(errorEncountered === 404 ? jobNotFoundErrorMessage : basicErrorMessage));
          }
        }
      }
    }
    if (isMounted() === false || errorEncountered !== undefined) {
      return;
    }
    fetchSelectedJob();
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [selectedJobId, isMounted, errorEncountered]);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const resizeHandler = (0, _react.useCallback)((0, _lodash.throttle)(e => {
    if (Math.abs(chartDimensions.width - e.width) > minElemAndChartDiff || Math.abs(chartDimensions.height - e.height) > minElemAndChartDiff) {
      setChartDimensions(e);
    }
  }, RESIZE_THROTTLE_TIME_MS), [chartDimensions.width, chartDimensions.height]);
  const autoZoomDuration = (0, _react.useMemo)(() => {
    var _selectedJobWrapper$j;
    if (!selectedJobWrapper) return;
    return mlTimeSeriesExplorerService === null || mlTimeSeriesExplorerService === void 0 ? void 0 : mlTimeSeriesExplorerService.getAutoZoomDuration((_selectedJobWrapper$j = selectedJobWrapper.job.analysis_config) === null || _selectedJobWrapper$j === void 0 ? void 0 : _selectedJobWrapper$j.bucket_span);
  }, [mlTimeSeriesExplorerService, selectedJobWrapper]);
  const appStateHandler = (0, _react.useCallback)((action, payload) => {
    /**
     * Empty zoom indicates that chart hasn't been rendered yet,
     * hence any updates prior that should replace the URL state.
     */
    switch (action) {
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_FORECAST_ID:
        if (onForecastIdChange) {
          onForecastIdChange(payload);
        }
        setSelectedForecastId(payload);
        setZoom(undefined);
        break;
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_ZOOM:
        setZoom(payload);
        break;
      case _timeseriesexplorer_constants.APP_STATE_ACTION.UNSET_ZOOM:
        setZoom(undefined);
        break;
    }
  }, [setZoom, setSelectedForecastId, onForecastIdChange]);
  const onForecastComplete = forecastEndTimestamp => {
    const {
      timefilter
    } = pluginStart.data.query.timefilter;
    const currentBounds = timefilter.getActiveBounds();
    if (forecastEndTimestamp && currentBounds !== null && currentBounds !== void 0 && currentBounds.max && currentBounds !== null && currentBounds !== void 0 && currentBounds.min && currentBounds.max.unix() * 1000 < forecastEndTimestamp) {
      const to = (0, _moment.default)(forecastEndTimestamp);
      timefilter.setTime({
        from: currentBounds.min,
        to,
        mode: 'absolute'
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: resizeHandler,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 5
    }
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    id: `mlSingleMetricViewerEmbeddableWrapper-${uuid}`,
    style: {
      width: '100%',
      overflowY: 'auto',
      overflowX: 'hidden',
      padding: '8px'
    },
    "data-test-subj": `mlSingleMetricViewer_${uuid}`,
    ref: resizeRef,
    css: [timeseriesExplorerStyles, annotationStyles],
    "data-shared-item": "" // TODO: Remove data-shared-item as part of https://github.com/elastic/kibana/issues/179376
    ,
    "data-rendering-count": 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      mlServices: {
        ...mlServices
      },
      ...coreStart,
      ...pluginStart
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_mlDatePicker.DatePickerContextProvider, (0, _extends2.default)({}, datePickerDeps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 271,
      columnNumber: 15
    }
  }), selectedJobId !== undefined && autoZoomDuration !== undefined && selectedJobId === (selectedJobWrapper === null || selectedJobWrapper === void 0 ? void 0 : selectedJobWrapper.job.job_id) && /*#__PURE__*/_react.default.createElement(_timeseriesexplorer_embeddable_chart.TimeSeriesExplorerEmbeddableChart, {
    api: api,
    chartWidth: chartDimensions.width - containerPadding,
    chartHeight: chartDimensions.height - containerPadding,
    dataViewsService: pluginStart.data.dataViews,
    toastNotificationService: toastNotificationService,
    appStateHandler: appStateHandler,
    autoZoomDuration: autoZoomDuration,
    bounds: bounds,
    dateFormatTz: _moment.tz.guess(),
    lastRefresh: lastRefresh !== null && lastRefresh !== void 0 ? lastRefresh : 0,
    previousRefresh: previousRefresh,
    selectedJobId: selectedJobId,
    selectedDetectorIndex: selectedDetectorIndex,
    selectedEntities: selectedEntities,
    selectedForecastId: selectedForecastId,
    tableInterval: "auto",
    tableSeverity: [{
      min: 0
    }],
    zoom: zoom,
    functionDescription: functionDescription,
    selectedJob: selectedJobWrapper.job,
    selectedJobStats: selectedJobWrapper.stats,
    onRenderComplete: onRenderComplete,
    onForecastComplete: onForecastComplete,
    shouldShowForecastButton: shouldShowForecastButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 21
    }
  }))))));
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = SingleMetricViewerWrapper;
module.exports = exports.default;