"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SingleMetricViewerInitializer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _locator = require("../../../common/constants/locator");
var _series_controls = require("../../application/timeseriesexplorer/components/series_controls");
var _timeseriesexplorer_constants = require("../../application/timeseriesexplorer/timeseriesexplorer_constants");
var _kibana = require("../../application/contexts/kibana");
var _job_selector = require("../../alerting/job_selector");
var _get_default_panel_title = require("./get_default_panel_title");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/embeddables/single_metric_viewer/single_metric_viewer_initializer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SingleMetricViewerInitializer = ({
  bounds,
  initialInput,
  onCreate,
  onCancel,
  mlApi
}) => {
  var _initialInput$title, _initialInput$selecte;
  const isMounted = (0, _useMountedState.default)();
  const newJobUrl = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB
  });
  const [jobId, setJobId] = (0, _react.useState)((initialInput === null || initialInput === void 0 ? void 0 : initialInput.jobIds) && (initialInput === null || initialInput === void 0 ? void 0 : initialInput.jobIds[0]));
  const titleManuallyChanged = (0, _react.useRef)(!!(initialInput !== null && initialInput !== void 0 && initialInput.title));
  const [job, setJob] = (0, _react.useState)();
  const [panelTitle, setPanelTitle] = (0, _react.useState)((_initialInput$title = initialInput === null || initialInput === void 0 ? void 0 : initialInput.title) !== null && _initialInput$title !== void 0 ? _initialInput$title : '');
  const [functionDescription, setFunctionDescription] = (0, _react.useState)(initialInput === null || initialInput === void 0 ? void 0 : initialInput.functionDescription);
  // Reset detector index and entities if the job has changed
  const [selectedDetectorIndex, setSelectedDetectorIndex] = (0, _react.useState)((_initialInput$selecte = initialInput === null || initialInput === void 0 ? void 0 : initialInput.selectedDetectorIndex) !== null && _initialInput$selecte !== void 0 ? _initialInput$selecte : 0);
  const [selectedEntities, setSelectedEntities] = (0, _react.useState)(initialInput === null || initialInput === void 0 ? void 0 : initialInput.selectedEntities);
  const [errorMessage, setErrorMessage] = (0, _react.useState)();
  const isPanelTitleValid = panelTitle.length > 0;
  (0, _react.useEffect)(function setUpPanel() {
    async function fetchJob() {
      const {
        jobs
      } = await mlApi.getJobs({
        jobId
      });
      if (isMounted() && jobs.length === 1) {
        setJob(jobs[0]);
        setErrorMessage(undefined);
      }
    }
    if (jobId) {
      if (!titleManuallyChanged.current) {
        setPanelTitle((0, _get_default_panel_title.getDefaultSingleMetricViewerPanelTitle)(jobId));
      }
      // Fetch job if a jobId has been selected and if there is no corresponding fetched job or the job selection has changed
      if (mlApi && jobId && jobId !== (job === null || job === void 0 ? void 0 : job.job_id)) {
        fetchJob().catch(error => {
          const errorMsg = (0, _mlErrorUtils.extractErrorMessage)(error);
          setErrorMessage(errorMsg);
        });
      }
    }
  }, [isMounted, jobId, mlApi, panelTitle, job === null || job === void 0 ? void 0 : job.job_id]);
  const handleStateUpdate = (action, payload) => {
    switch (action) {
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_ENTITIES:
        setSelectedEntities(payload);
        break;
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_FUNCTION_DESCRIPTION:
        setFunctionDescription(payload);
        break;
      case _timeseriesexplorer_constants.APP_STATE_ACTION.SET_DETECTOR_INDEX:
        setSelectedDetectorIndex(payload);
        break;
      default:
        break;
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.SingleMetricViewerEmbeddable.setupModal.title",
    defaultMessage: "Single metric viewer configuration",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_job_selector.JobSelectorControl, (0, _extends2.default)({
    adJobsApiService: mlApi.jobs,
    createJobUrl: newJobUrl,
    jobsAndGroupIds: jobId ? [jobId] : undefined,
    onChange: update => {
      setJobId((update === null || update === void 0 ? void 0 : update.jobIds) && (update === null || update === void 0 ? void 0 : update.jobIds[0]));
      // Reset values when selected job has changed
      setSelectedDetectorIndex(0);
      setSelectedEntities(undefined);
      setFunctionDescription(undefined);
    }
  }, errorMessage && {
    errors: [errorMessage]
  }, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 11
    }
  })), job !== null && job !== void 0 && job.job_id && jobId && jobId === job.job_id ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.singleMetricViewerEmbeddable.panelTitleLabel",
      defaultMessage: "Panel title",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 17
      }
    }),
    isInvalid: !isPanelTitleValid,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "panelTitleInput",
    id: "panelTitle",
    name: "panelTitle",
    value: panelTitle,
    onChange: e => {
      titleManuallyChanged.current = true;
      setPanelTitle(e.target.value);
    },
    isInvalid: !isPanelTitleValid,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 11
    }
  }), job !== null && job !== void 0 && job.job_id && jobId && jobId === job.job_id ? /*#__PURE__*/_react.default.createElement(_series_controls.SeriesControls, {
    selectedJobId: jobId,
    job: job,
    direction: "column",
    appStateHandler: handleStateUpdate,
    selectedDetectorIndex: selectedDetectorIndex,
    selectedEntities: selectedEntities,
    bounds: bounds,
    functionDescription: functionDescription,
    setFunctionDescription: setFunctionDescription,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 13
    }
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'spaceBetween',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "aria-label": _i18n.i18n.translate('xpack.ml.singleMetricViewerEmbeddable.setupModal.cancelButtonAriaLabel', {
      defaultMessage: 'Cancel'
    }),
    onClick: onCancel,
    "data-test-subj": "mlsingleMetricViewerInitializerCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.singleMetricViewerEmbeddable.setupModal.cancelButtonLabel",
    defaultMessage: "Cancel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlSingleMetricViewerInitializerConfirmButton",
    isDisabled: !isPanelTitleValid || errorMessage !== undefined || !jobId || !job,
    onClick: onCreate.bind(null, {
      jobIds: jobId ? [jobId] : [],
      functionDescription,
      panelTitle,
      selectedDetectorIndex,
      selectedEntities
    }),
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 213,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.singleMetricViewerEmbeddable.setupModal.confirmButtonLabel",
    defaultMessage: "Confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  }))))));
};
exports.SingleMetricViewerInitializer = SingleMetricViewerInitializer;