"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeSeriesExplorerControls = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/presentation-util-plugin/public");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _constants = require("../../../../cases/constants");
var _kibana = require("../../../contexts/kibana");
var _use_cases_modal = require("../../../contexts/kibana/use_cases_modal");
var _get_default_panel_title = require("../../../../embeddables/single_metric_viewer/get_default_panel_title");
var _constants2 = require("../../../../embeddables/constants");
var _forecasting_modal = require("../forecasting_modal/forecasting_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/timeseriesexplorer/components/timeseriesexplorer_controls/timeseriesexplorer_controls.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SavedObjectSaveModalDashboard = (0, _public.withSuspense)(_public.LazySavedObjectSaveModalDashboard);
function getDefaultEmbeddablePanelConfig(jobId, queryString) {
  return {
    title: (0, _get_default_panel_title.getDefaultSingleMetricViewerPanelTitle)(jobId).concat(queryString ? `- ${queryString}` : ''),
    id: (0, _eui.htmlIdGenerator)()()
  };
}
const TimeSeriesExplorerControls = ({
  forecastId,
  selectedDetectorIndex,
  selectedEntities,
  selectedJobId,
  showAnnotations,
  showAnnotationsCheckbox,
  showForecast,
  showForecastCheckbox,
  showModelBounds,
  showModelBoundsCheckbox,
  onShowAnnotationsChange,
  onShowModelBoundsChange,
  onShowForecastChange,
  fullRefresh,
  loading,
  hasResults,
  setForecastId,
  selectedJob,
  entities,
  jobs,
  jobState,
  earliestRecordTimestamp,
  latestRecordTimestamp
}) => {
  var _capabilities$dashboa, _capabilities$dashboa2;
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const [createInDashboard, setCreateInDashboard] = (0, _react.useState)(false);
  const {
    services: {
      application: {
        capabilities
      },
      cases,
      embeddable
    }
  } = (0, _kibana.useMlKibana)();
  const globalTimeRange = (0, _mlDatePicker.useTimeRangeUpdates)(true);
  const canEditDashboards = (_capabilities$dashboa = (_capabilities$dashboa2 = capabilities.dashboard_v2) === null || _capabilities$dashboa2 === void 0 ? void 0 : _capabilities$dashboa2.createNew) !== null && _capabilities$dashboa !== void 0 ? _capabilities$dashboa : false;
  const closePopoverOnAction = (0, _react.useCallback)(actionCallback => {
    return () => {
      setIsMenuOpen(false);
      actionCallback();
    };
  }, [setIsMenuOpen]);
  const openCasesModalCallback = (0, _use_cases_modal.useCasesModal)(_constants2.ANOMALY_SINGLE_METRIC_VIEWER_EMBEDDABLE_TYPE, _constants.CASES_TOAST_MESSAGES_TITLES.SINGLE_METRIC_VIEWER);
  const showControls = (fullRefresh === false || loading === false) && hasResults === true && jobs.length > 0;
  const menuPanels = [{
    id: 0,
    items: [{
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.timeseriesExplorer.addToDashboardLabel",
        defaultMessage: "Add to dashboard",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 13
        }
      }),
      icon: 'dashboardApp',
      onClick: closePopoverOnAction(() => {
        setCreateInDashboard(true);
      })
    }]
  }];
  const casesPrivileges = cases === null || cases === void 0 ? void 0 : cases.helpers.canUseCases();
  if (!!(casesPrivileges !== null && casesPrivileges !== void 0 && casesPrivileges.create) || !!(casesPrivileges !== null && casesPrivileges !== void 0 && casesPrivileges.update)) {
    menuPanels[0].items.push({
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.timeseriesExplorer.addToCaseLabel",
        defaultMessage: "Add to case",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 9
        }
      }),
      icon: 'casesApp',
      onClick: closePopoverOnAction(() => {
        openCasesModalCallback({
          forecastId,
          jobIds: [selectedJobId],
          selectedDetectorIndex,
          selectedEntities,
          timeRange: globalTimeRange
        });
      })
    });
  }
  const onSaveCallback = (0, _react.useCallback)(async ({
    dashboardId,
    newTitle,
    newDescription
  }) => {
    const stateTransfer = embeddable.getStateTransfer();
    const config = getDefaultEmbeddablePanelConfig(selectedJobId);
    const embeddableInput = {
      id: config.id,
      title: newTitle,
      description: newDescription,
      forecastId,
      jobIds: [selectedJobId],
      selectedDetectorIndex,
      selectedEntities
    };
    const state = {
      serializedState: {
        rawState: embeddableInput,
        references: []
      },
      type: _constants2.ANOMALY_SINGLE_METRIC_VIEWER_EMBEDDABLE_TYPE
    };
    const path = dashboardId === 'new' ? '#/create' : `#/view/${dashboardId}`;
    stateTransfer.navigateToWithEmbeddablePackage('dashboards', {
      state,
      path
    });
  }, [embeddable, selectedJobId, selectedDetectorIndex, selectedEntities, forecastId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      float: 'right'
    },
    alignItems: "center",
    justifyContent: "flexEnd",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, showModelBoundsCheckbox && showControls && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: '170px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "toggleModelBoundsCheckbox",
    label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.showModelBoundsLabel', {
      defaultMessage: 'show model bounds'
    }),
    checked: showModelBounds,
    onChange: onShowModelBoundsChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 15
    }
  }))), showAnnotationsCheckbox && showControls && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "toggleAnnotationsCheckbox",
    label: _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.annotationsLabel', {
      defaultMessage: 'annotations'
    }),
    checked: showAnnotations,
    onChange: onShowAnnotationsChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }))), showForecastCheckbox && showControls && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      minWidth: '120px'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "toggleShowForecastCheckbox",
    label: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": 'mlForecastCheckbox',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 19
      }
    }, _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.showForecastLabel', {
      defaultMessage: 'show forecast'
    })),
    checked: showForecast,
    onChange: onShowForecastChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 267,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_forecasting_modal.ForecastingModal, {
    job: selectedJob,
    jobState: jobState,
    detectorIndex: selectedDetectorIndex,
    entities: entities,
    earliestRecordTimestamp: earliestRecordTimestamp,
    latestRecordTimestamp: latestRecordTimestamp,
    setForecastId: setForecastId,
    className: "forecast-controls",
    selectedForecastId: forecastId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 11
    }
  })), canEditDashboards && showControls ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.ml.explorer.swimlaneActions', {
        defaultMessage: 'Actions'
      }),
      color: "text",
      display: "base",
      isSelected: isMenuOpen,
      iconType: "boxesHorizontal",
      onClick: setIsMenuOpen.bind(null, !isMenuOpen),
      "data-test-subj": "mlAnomalyTimelinePanelMenu",
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 19
      }
    }),
    isOpen: isMenuOpen,
    closePopover: setIsMenuOpen.bind(null, false),
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: menuPanels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 17
    }
  })))) : null), createInDashboard ? /*#__PURE__*/_react.default.createElement(SavedObjectSaveModalDashboard, {
    canSaveByReference: false,
    objectType: _i18n.i18n.translate('xpack.ml.cases.singleMetricViewer.displayName', {
      defaultMessage: 'Single Metric Viewer'
    }),
    documentInfo: {
      title: (0, _get_default_panel_title.getDefaultSingleMetricViewerPanelTitle)(selectedJobId)
    },
    onClose: () => setCreateInDashboard(false),
    onSave: onSaveCallback,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 9
    }
  }) : null);
};
exports.TimeSeriesExplorerControls = TimeSeriesExplorerControls;