"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewPanelDefaultState = exports.default = exports.OverviewPage = exports.MLOverviewCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esqlUtils = require("@kbn/esql-utils");
var _upgrade = require("../components/upgrade");
var _help_menu = require("../components/help_menu");
var _kibana = require("../contexts/kibana");
var _use_create_url = require("../contexts/kibana/use_create_url");
var _locator = require("../../../common/constants/locator");
var _page_header = require("../components/page_header");
var _anomaly_detection_overview = require("./components/anomaly_detection_overview");
var _data_frame_analytics_overview = require("./components/data_frame_analytics_overview");
var _ml = require("../contexts/ml");
var _data_visualizer_grid = require("./data_visualizer_grid");
var _overview_ml_footer_item = require("./components/overview_ml_footer_item");
var _welcomeLight = _interopRequireDefault(require("./components/welcome--light.png"));
var _welcomeDark = _interopRequireDefault(require("./components/welcome--dark.png"));
var _check_capabilities = require("../capabilities/check_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/overview/overview_ml_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const overviewPanelDefaultState = exports.overviewPanelDefaultState = Object.freeze({
  nodes: true,
  adJobs: true,
  dfaJobs: true
});
const MLOverviewCard = ({
  layout,
  path,
  title,
  description,
  iconType,
  buttonLabel,
  cardDataTestSubj,
  buttonDataTestSubj,
  buttonType = 'empty'
}) => {
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const ButtonComponent = buttonType === 'empty' ? _eui.EuiButtonEmpty : _eui.EuiButton;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": cardDataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: layout,
    "data-test-subj": cardDataTestSubj,
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      iconType: iconType,
      onClick: () => navigateToPath(path),
      "aria-labelledby": "mlOverviewCardTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 11
      }
    }),
    title: title,
    titleSize: "s",
    titleElement: "h3",
    id: "mlOverviewCardTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(ButtonComponent, {
    flush: "left",
    target: "_self",
    onClick: () => navigateToPath(path),
    "data-test-subj": buttonDataTestSubj,
    "aria-label": buttonLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, buttonLabel)));
};
exports.MLOverviewCard = MLOverviewCard;
const OverviewPage = () => {
  var _user$user$username;
  const [user, setUser] = (0, _react.useState)();
  const {
    services: {
      docLinks,
      uiSettings,
      userProfile
    }
  } = (0, _kibana.useMlKibana)();
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const isDarkTheme = colorMode === 'DARK';
  const {
    isADEnabled,
    isDFAEnabled,
    isNLPEnabled
  } = (0, _ml.useEnabledFeatures)();
  const [canUseAiops] = (0, _check_capabilities.usePermissionCheck)(['canUseAiops']);
  const helpLink = docLinks.links.ml.guide;
  const trainedModelsDocLink = docLinks.links.ml.trainedModels;
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const navigateToTrainedModels = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)('', _locator.ML_PAGES.TRAINED_MODELS_MANAGE);
  const navigateToStackManagementMLOverview = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)('', 'overview');
  const isEsqlEnabled = (0, _react.useMemo)(() => uiSettings.get(_esqlUtils.ENABLE_ESQL), [uiSettings]);
  (0, _react.useEffect)(function loadUserName() {
    async function loadUser() {
      const currentUser = await userProfile.getCurrent();
      setUser(currentUser);
    }
    loadUser();
  }, [userProfile]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, {
    restrictWidth: 1200,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      alt: _i18n.i18n.translate('xpack.ml.overview.welcomeBanner.header.imageAlt', {
        defaultMessage: 'Welcome to the Machine Learning Hub'
      }),
      src: isDarkTheme ? _welcomeDark.default : _welcomeLight.default,
      size: "l",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 11
      }
    })],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }, Boolean(user) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 17
    }
  }, user ? _i18n.i18n.translate('xpack.ml.overview.welcomeBanner.header.greeting.customTitle', {
    defaultMessage: '👋 Hi {name}!',
    values: {
      name: (_user$user$username = user.user.username) !== null && _user$user$username !== void 0 ? _user$user$username : ''
    }
  }) : _i18n.i18n.translate('xpack.ml.overview.welcomeBanner.header.greeting.defaultTitle', {
    defaultMessage: '👋 Hi'
  })))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.overview.welcomeBanner.header.title",
    defaultMessage: "Welcome to the Machine Learning Hub",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.ml.overview.welcomeBanner.header.titleDescription', {
    defaultMessage: 'Analyze your data and generate models for its patterns of behavior.'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_upgrade.UpgradeWarning, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 9
    }
  }, isADEnabled || isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.ml.overview.analyzeYourDataTitle', {
    defaultMessage: 'Analyze your data'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 19
    }
  }, isADEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlOverviewAnomalyDetectionCard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_anomaly_detection_overview.AnomalyDetectionOverviewCard, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 25
    }
  })) : null, isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "mlOverviewCardDataFrameAnalytics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_data_frame_analytics_overview.DataFrameAnalyticsOverviewCard, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 25
    }
  })) : null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 15
    }
  })) : null, canUseAiops ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.ml.overview.aiopsLabsTitle', {
    defaultMessage: 'AIOps Labs'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    gutterSize: "m",
    columns: 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    textAlign: "left",
    layout: "vertical",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      onClick: () => navigateToPath('/aiops/log_rate_analysis_index_select'),
      iconType: "logRateAnalysis",
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.logRateAnalysis.title', {
        defaultMessage: 'Log Rate Analysis'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 25
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logRateAnalysis.title",
      defaultMessage: "Log Rate Analysis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 265,
        columnNumber: 25
      }
    }),
    titleElement: "h3",
    titleSize: "s",
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logRateAnalysis.description",
      defaultMessage: "Advanced statistical methods to identify reasons for increases or decreases in log rates and displays the statistically significant data in a tabular format.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 274,
        columnNumber: 27
      }
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      target: "_self",
      onClick: () => navigateToPath('/aiops/log_rate_analysis_index_select'),
      "data-test-subj": "mlOverviewCardLogRateAnalysisButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 281,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logRateAnalysis.startAnalysisButton",
      defaultMessage: "Start analysis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 287,
        columnNumber: 27
      }
    })),
    "data-test-subj": "mlOverviewCardLogRateAnalysis",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    textAlign: "left",
    layout: "vertical",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      iconType: "logPatternAnalysis",
      onClick: () => navigateToPath('/aiops/log_categorization_index_select'),
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.logPatternAnalysisTitle', {
        defaultMessage: 'Log Pattern Analysis'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 303,
        columnNumber: 25
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logPatternAnalysisTitle",
      defaultMessage: "Log Pattern Analysis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 314,
        columnNumber: 25
      }
    }),
    titleElement: "h3",
    titleSize: "s",
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logPatternAnalysisDescription",
      defaultMessage: "Find patterns in unstructured log messages and make it easier to examine your data.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 323,
        columnNumber: 27
      }
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      target: "_self",
      onClick: () => navigateToPath('/aiops/log_categorization_index_select'),
      "data-test-subj": "mlOverviewCardLogPatternAnalysisButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 330,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.logPatternAnalysis.startAnalysisButton",
      defaultMessage: "Start analysis",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 336,
        columnNumber: 27
      }
    })),
    "data-test-subj": "mlOverviewCardLogPatternAnalysis",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    textAlign: "left",
    layout: "vertical",
    hasBorder: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      display: "base",
      size: "s",
      iconType: "changePointDetection",
      onClick: () => navigateToPath('/aiops/change_point_detection_index_select'),
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.changePointDetection.title', {
        defaultMessage: 'Change Point Detection'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 351,
        columnNumber: 25
      }
    }),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.changePointDetection.title",
      defaultMessage: "Change Point Detection",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 367,
        columnNumber: 25
      }
    }),
    titleElement: "h3",
    titleSize: "s",
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.changePointDetection.description",
      defaultMessage: "Change point detection uses the change point aggregation to detect distribution changes, trend changes, and other statistically significant change points in a metric of your time series data.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 376,
        columnNumber: 27
      }
    })),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      target: "_self",
      onClick: () => navigateToPath('/aiops/change_point_detection_index_select'),
      "data-test-subj": "mlOverviewCardChangePointDetectionButton",
      "aria-label": _i18n.i18n.translate('xpack.ml.overview.changePointDetection.startDetectionButton', {
        defaultMessage: 'Start detection'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 383,
        columnNumber: 25
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.changePointDetection.startDetectionButton",
      defaultMessage: "Start detection",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 27
      }
    })),
    "data-test-subj": "mlOverviewCardChangePointDetection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 21
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 408,
      columnNumber: 15
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 411,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 412,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 413,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.ml.overview.visualizeYourDataTitle', {
    defaultMessage: 'Visualize your data'
  }))), /*#__PURE__*/_react.default.createElement(_data_visualizer_grid.DataVisualizerGrid, {
    isEsqlEnabled: isEsqlEnabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 419,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 422,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 424,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 425,
      columnNumber: 7
    }
  }, isADEnabled || isNLPEnabled || isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 427,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_ml_footer_item.OverviewFooterItem, {
    icon: "dashboardApp",
    title: _i18n.i18n.translate('xpack.ml.overview.manageMlAssetsTitle', {
      defaultMessage: 'Manage ML Assets'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.manageMlAssetsDescription', {
      defaultMessage: 'Overview of your ML jobs, memory usage, and notifications.'
    }),
    docLink: helpLink,
    callToAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: navigateToStackManagementMLOverview,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 438,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.ml.overview.goToManagmentLink', {
      defaultMessage: 'Go to Management'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 428,
      columnNumber: 13
    }
  })) : null, isNLPEnabled || isDFAEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 448,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_ml_footer_item.OverviewFooterItem, {
    icon: "machineLearningApp",
    title: _i18n.i18n.translate('xpack.ml.overview.trainedModelsTitle', {
      defaultMessage: 'Trained Models'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.trainedModelsDescription', {
      defaultMessage: 'Add or manage Trained Models. See deployment stats or add a new deployment.'
    }),
    docLink: trainedModelsDocLink,
    callToAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: navigateToTrainedModels,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 460,
        columnNumber: 17
      }
    }, _i18n.i18n.translate('xpack.ml.overview.manageTrainedModelsLink', {
      defaultMessage: 'Manage Trained Models'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 449,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 469,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_ml_footer_item.OverviewFooterItem, {
    icon: "documentation",
    title: _i18n.i18n.translate('xpack.ml.overview.browseDocumentationTitle', {
      defaultMessage: 'Browse documentation'
    }),
    description: _i18n.i18n.translate('xpack.ml.overview.browseDocumentationDescription', {
      defaultMessage: 'In-depth guides on Elastic Machine Learning.'
    }),
    docLink: helpLink,
    callToAction: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: helpLink,
      external: true,
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 480,
        columnNumber: 15
      }
    }, _i18n.i18n.translate('xpack.ml.overview.startReadingDocsLink', {
      defaultMessage: 'Start Reading'
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 470,
      columnNumber: 11
    }
  }))));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.OverviewPage = OverviewPage;
var _default = exports.default = OverviewPage;