"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../../../contexts/kibana");
var _job_creator_context = require("../../../job_creator_context");
var _job_creator = require("../../../../../common/job_creator");
var _ml_server_info = require("../../../../../../../services/ml_server_info");
var _common = require("../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/summary_step/components/job_details/job_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const JobDetails = () => {
  const {
    jobCreator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  // TODO should use fieldFormats instead
  const dateFormat = uiSettings.get('dateFormat');
  const {
    anomaly_detectors: anomalyDetectors
  } = (0, _ml_server_info.getNewJobDefaults)();
  const isAdvanced = (0, _job_creator.isAdvancedJobCreator)(jobCreator);
  const modelMemoryLimitDefault = anomalyDetectors.model_memory_limit || '';
  const modelMemoryLimit = jobCreator.modelMemoryLimit !== null ? jobCreator.modelMemoryLimit : /*#__PURE__*/_react.default.createElement(_common.Italic, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, `${modelMemoryLimitDefault} (${_common.defaultLabel})`);
  const jobDetails = [{
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.jobDetails.title', {
      defaultMessage: 'Job ID'
    }),
    description: jobCreator.jobId
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.jobDescription.title', {
      defaultMessage: 'Job description'
    }),
    description: jobCreator.description.length > 0 ? jobCreator.description : /*#__PURE__*/_react.default.createElement(_common.Italic, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.summaryStep.jobDetails.jobDescription.placeholder",
      defaultMessage: "No description provided",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 13
      }
    }))
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.groups.title', {
      defaultMessage: 'Groups'
    }),
    description: jobCreator.groups.length > 0 ? jobCreator.groups.join(', ') : /*#__PURE__*/_react.default.createElement(_common.Italic, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.summaryStep.jobDetails.groups.placeholder",
      defaultMessage: "No groups selected",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    }))
  }];
  const detectorDetails = [{
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.bucketSpan.title', {
      defaultMessage: 'Bucket span'
    }),
    // @ts-expect-error bucketSpan is of type estypes.Duration
    description: jobCreator.bucketSpan
  }];
  if ((0, _job_creator.isMultiMetricJobCreator)(jobCreator)) {
    detectorDetails.push({
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.splitField.title', {
        defaultMessage: 'Split field'
      }),
      description: (0, _job_creator.isMultiMetricJobCreator)(jobCreator) && jobCreator.splitField !== null ? jobCreator.splitField.name : /*#__PURE__*/_react.default.createElement(_common.Italic, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 104,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.newJob.wizard.summaryStep.jobDetails.splitField.placeholder",
        defaultMessage: "No split field selected",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 105,
          columnNumber: 13
        }
      }))
    });
  }
  if ((0, _job_creator.isPopulationJobCreator)(jobCreator)) {
    detectorDetails.push({
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.populationField.title', {
        defaultMessage: 'Population field'
      }),
      description: (0, _job_creator.isPopulationJobCreator)(jobCreator) && jobCreator.populationField !== null ? jobCreator.populationField.name : /*#__PURE__*/_react.default.createElement("span", {
        style: {
          fontStyle: jobCreator.populationField !== null ? 'inherit' : 'italic'
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.newJob.wizard.summaryStep.jobDetails.populationField.placeholder",
        defaultMessage: "No population field selected",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 13
        }
      }))
    });
  }
  if (isAdvanced && jobCreator.categorizationFieldName !== null) {
    detectorDetails.push({
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.categorizationField.title', {
        defaultMessage: 'Categorization field'
      }),
      description: jobCreator.categorizationFieldName
    });
  }
  if (isAdvanced && jobCreator.summaryCountFieldName !== null) {
    detectorDetails.push({
      title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.summaryCountField.title', {
        defaultMessage: 'Summary count field'
      }),
      description: jobCreator.summaryCountFieldName
    });
  }
  detectorDetails.push({
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.influencers.title', {
      defaultMessage: 'Influencers'
    }),
    description: jobCreator.influencers.length > 0 ? jobCreator.influencers.join(', ') : /*#__PURE__*/_react.default.createElement(_common.Italic, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.summaryStep.jobDetails.influencers.placeholder",
      defaultMessage: "No influencers selected",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    }))
  });
  const advancedDetails = [{
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.enableModelPlot.title', {
      defaultMessage: 'Enable model plot'
    }),
    description: jobCreator.modelPlot ? _common.trueLabel : _common.falseLabel
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.useDedicatedIndex.title', {
      defaultMessage: 'Use dedicated index'
    }),
    description: jobCreator.useDedicatedIndex ? _common.trueLabel : _common.falseLabel
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.jobDetails.modelMemoryLimit.title', {
      defaultMessage: 'Model memory limit'
    }),
    description: modelMemoryLimit
  }];
  const timeRangeDetails = [{
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.timeRange.start.title', {
      defaultMessage: 'Start'
    }),
    description: (0, _moment.default)(jobCreator.start).format(dateFormat)
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.timeRange.end.title', {
      defaultMessage: 'End'
    }),
    description: (0, _moment.default)(jobCreator.end).format(dateFormat)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: jobDetails,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: detectorDetails,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: advancedDetails,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 9
    }
  })), isAdvanced === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: timeRangeDetails,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 11
    }
  })));
};
exports.JobDetails = JobDetails;