"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDriftIndexPatternsEditor = DataDriftIndexPatternsEditor;
exports.matchedIndicesDefault = exports.canAppendWildcard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _lodash = require("lodash");
var _toast_notification_service = require("../../services/toast_notification_service");
var _locator = require("../../../../common/constants/locator");
var _kibana = require("../../contexts/kibana");
var _data_view_editor = require("./data_view_editor");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/datavisualizer/data_drift/data_drift_index_patterns_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const matchedIndicesDefault = exports.matchedIndicesDefault = {
  allIndices: [],
  exactMatchedIndices: [],
  partialMatchedIndices: [],
  visibleIndices: []
};
const canAppendWildcard = keyPressed => {
  // If it's not a letter, number or is something longer, reject it
  if (!keyPressed || !/[a-z0-9]/i.test(keyPressed) || keyPressed.length !== 1) {
    return false;
  }
  return true;
};
exports.canAppendWildcard = canAppendWildcard;
const getDefaultIndexPattern = (referenceIndexPattern, comparisonIndexPattern) => referenceIndexPattern === comparisonIndexPattern ? referenceIndexPattern : `${referenceIndexPattern},${comparisonIndexPattern}`;
function DataDriftIndexPatternsEditor({
  referenceDataViewEditorService,
  comparisonDataViewEditorService,
  initialReferenceIndexPattern,
  initialComparisonIndexPattern
}) {
  const {
    services: {
      dataViewEditor,
      data: {
        dataViews
      }
    }
  } = (0, _kibana.useMlKibana)();
  const locator = (0, _kibana.useMlLocator)();
  const canEditDataView = dataViewEditor === null || dataViewEditor === void 0 ? void 0 : dataViewEditor.userPermissions.editDataView();
  const [timeField, setTimeField] = (0, _react.useState)([]);
  const [dataViewName, setDataViewName] = (0, _react.useState)('');
  const [dataViewMsg, setDataViewMsg] = (0, _react.useState)();
  const [foundDataViewId, setFoundDataViewId] = (0, _react.useState)();
  const [refError, setRefError] = (0, _react.useState)();
  const [comparisonError, setComparisonError] = (0, _react.useState)();
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();

  // For the purpose of data drift, the two datasets need to have the same common timestamp field if they exist
  // In data view management, creating a data view provides union of all the timestamp fields
  // Here, we need the intersection of two sets instead
  const combinedTimeFieldOptions$ = (0, _react.useMemo)(() => {
    return (0, _rxjs.combineLatest)([referenceDataViewEditorService === null || referenceDataViewEditorService === void 0 ? void 0 : referenceDataViewEditorService.timestampFieldOptions$, comparisonDataViewEditorService === null || comparisonDataViewEditorService === void 0 ? void 0 : comparisonDataViewEditorService.timestampFieldOptions$]).pipe((0, _rxjs.map)(([referenceTimeFieldOptions, productionTimeFieldOptions]) => {
      const intersectedTimeFields = (0, _lodash.intersectionBy)(referenceTimeFieldOptions, productionTimeFieldOptions, d => d.fieldName).map(({
        display,
        fieldName
      }) => ({
        label: display,
        value: fieldName
      }));
      return intersectedTimeFields;
    }));
  }, [comparisonDataViewEditorService, referenceDataViewEditorService]);
  const combinedTimeFieldOptions = (0, _useObservable.default)(combinedTimeFieldOptions$, []);
  const [referenceIndexPattern, setReferenceIndexPattern] = (0, _react.useState)(initialReferenceIndexPattern !== null && initialReferenceIndexPattern !== void 0 ? initialReferenceIndexPattern : '');
  const [comparisonIndexPattern, setComparisonIndexPattern] = (0, _react.useState)(initialComparisonIndexPattern !== null && initialComparisonIndexPattern !== void 0 ? initialComparisonIndexPattern : '');
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const abortCtrl = (0, _react.useRef)(new AbortController());
  (0, _react.useEffect)(() => {
    let unmounted = false;
    if (!unmounted && Array.isArray(combinedTimeFieldOptions) && combinedTimeFieldOptions.length > 0 && timeField.length === 0) {
      setTimeField([combinedTimeFieldOptions[0]]);
    }
    return () => {
      unmounted = true;
    };
  }, [combinedTimeFieldOptions, timeField]);
  (0, _react.useEffect)(function validateMatchingDataViews() {
    let unmounted = false;
    const getMatchingDataView = async () => {
      abortCtrl.current.abort();
      abortCtrl.current = new AbortController();
      setDataViewMsg(undefined);
      setFoundDataViewId(undefined);
      if (!unmounted && referenceIndexPattern && comparisonIndexPattern) {
        const indicesName = getDefaultIndexPattern(referenceIndexPattern, comparisonIndexPattern);
        const matchingDataViews = await dataViews.find(indicesName);
        const timeFieldName = Array.isArray(timeField) && timeField.length > 0 && timeField[0].value !== '' ? timeField[0].value : undefined;
        if (Array.isArray(matchingDataViews) && matchingDataViews.length > 0) {
          const foundDataView = matchingDataViews.find(d => {
            return d.timeFieldName === timeFieldName;
          });
          if (foundDataView) {
            setFoundDataViewId(foundDataView.id);
          } else {
            setDataViewMsg(_i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.hasDataViewWithDifferentTimeField', {
              defaultMessage: `Found a data view matching pattern ''{indexPattern}'' but with a different time field. Creating a new data view to analyze data drift.`,
              values: {
                indexPattern: indicesName
              }
            }));
          }
        }
      }
    };
    getMatchingDataView();
    return () => {
      var _abortCtrl$current;
      (_abortCtrl$current = abortCtrl.current) === null || _abortCtrl$current === void 0 ? void 0 : _abortCtrl$current.abort();
      unmounted = true;
    };
  }, [referenceIndexPattern, comparisonIndexPattern, timeField, dataViews]);
  const createDataViewAndRedirectToDataDriftPage = (0, _lodash.debounce)(async (createAdHocDV = false) => {
    // Create adhoc data view
    const indicesName = getDefaultIndexPattern(referenceIndexPattern, comparisonIndexPattern);
    const timeFieldName = Array.isArray(timeField) && timeField.length > 0 ? timeField[0].value : undefined;
    let dataView;
    try {
      var _dataView;
      if (!foundDataViewId) {
        const defaultDataViewName = dataViewMsg === undefined ? indicesName : `${indicesName}${timeFieldName ? '-' + timeFieldName : ''}`;
        const modifiedDataViewName = dataViewName === '' ? defaultDataViewName : dataViewName;
        if (canEditDataView && createAdHocDV === false) {
          dataView = await dataViews.createAndSave({
            title: indicesName,
            name: modifiedDataViewName,
            timeFieldName
          });
        } else {
          dataView = await dataViews.create({
            title: indicesName,
            name: modifiedDataViewName,
            timeFieldName
          });
        }
      }
      const dataViewId = foundDataViewId !== null && foundDataViewId !== void 0 ? foundDataViewId : (_dataView = dataView) === null || _dataView === void 0 ? void 0 : _dataView.id;
      const url = await locator.getUrl({
        page: _locator.ML_PAGES.DATA_DRIFT,
        pageState: {
          index: dataViewId,
          reference: encodeURIComponent(referenceIndexPattern),
          comparison: encodeURIComponent(comparisonIndexPattern),
          timeFieldName
        }
      });
      await navigateToPath(url);
    } catch (e) {
      toastNotificationService.displayErrorToast(e);
    }
  }, 400);
  const hasError = refError !== undefined || comparisonError !== undefined || !comparisonIndexPattern || !referenceIndexPattern;
  const firstSetOfSteps = [{
    title: _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.enterReferenceDataTitle', {
      defaultMessage: 'Enter index pattern for reference data'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_data_view_editor.DataViewEditor, {
      id: 'reference',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataDrift.indexPatternsEditor.referenceData",
        defaultMessage: "Index pattern",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 253,
          columnNumber: 15
        }
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataDrift.indexPatternsEditor.requireSameTimeFieldHelpText",
        defaultMessage: "To view the changes in the data over time, reference and comparison data can have different index patterns, but they must have the same time field.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 15
        }
      }),
      dataViewEditorService: referenceDataViewEditorService,
      indexPattern: referenceIndexPattern,
      setIndexPattern: setReferenceIndexPattern,
      onError: setRefError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 250,
        columnNumber: 11
      }
    }))
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.enterComparisonDataTitle', {
      defaultMessage: 'Enter index pattern for comparison data'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_data_view_editor.DataViewEditor, {
      id: 'comparison',
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataDrift.indexPatternsEditor.comparisonDataIndexPatternHelp",
        defaultMessage: "Index pattern",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 281,
          columnNumber: 15
        }
      }),
      helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.dataDrift.indexPatternsEditor.requireSameTimeFieldHelpText",
        defaultMessage: "To view the changes in the data over time, reference and comparison data can have different index patterns, but they must have the same time field.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 287,
          columnNumber: 15
        }
      }),
      dataViewEditorService: comparisonDataViewEditorService,
      indexPattern: comparisonIndexPattern,
      setIndexPattern: setComparisonIndexPattern,
      onError: setComparisonError,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 278,
        columnNumber: 11
      }
    }))
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.additionalSettingsTitle', {
      defaultMessage: 'Additional settings'
    }),
    children: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 9
      }
    }, combinedTimeFieldOptions.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.timestampFieldLabel', {
        defaultMessage: 'Timestamp field'
      }),
      fullWidth: true,
      color: 'disabled',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 307,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.timestampFieldOptions', {
        defaultMessage: 'Select an optional timestamp field'
      }),
      singleSelection: {
        asPlainText: true
      },
      options: combinedTimeFieldOptions,
      selectedOptions: timeField,
      onChange: newValue => {
        if (newValue.length === 0) {
          // Don't allow clearing the type. One must always be selected
          return;
        }
        setTimeField(newValue);
      },
      isClearable: false,
      isDisabled: comparisonIndexPattern === '' && referenceIndexPattern === '',
      "data-test-subj": "mlDataDriftTimestampField",
      "aria-label": _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.timestampSelectAriaLabel', {
        defaultMessage: 'Timestamp field'
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 315,
        columnNumber: 17
      }
    }))) : null, !foundDataViewId ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.dataViewName', {
        defaultMessage: 'Data view name'
      }),
      helpText: _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.dataViewHelpText', {
        defaultMessage: 'Optional data view name.'
      }) + (referenceIndexPattern && comparisonIndexPattern ? ` ${_i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.defaultDataViewHelpText', {
        defaultMessage: 'Default to {fallbackDataViewName} if not set.',
        values: {
          fallbackDataViewName: getDefaultIndexPattern(referenceIndexPattern, comparisonIndexPattern)
        }
      })}` : ''),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 347,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: dataViewName,
      onChange: e => {
        setDataViewName(e.target.value);
      },
      fullWidth: true,
      "data-test-subj": "dataDriftDataViewNameInput",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 372,
        columnNumber: 15
      }
    })) : null, dataViewMsg ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "primary",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 383,
        columnNumber: 26
      }
    }, dataViewMsg) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      id: "analyzeDriftData",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 385,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 386,
        columnNumber: 13
      }
    }, canEditDataView && foundDataViewId === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 388,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      disabled: hasError,
      onClick: createDataViewAndRedirectToDataDriftPage.bind(null, true),
      iconType: "visTagCloud",
      "data-test-subj": "analyzeDataDriftWithoutSavingButton",
      "aria-label": _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.analyzeDataDriftWithoutSavingLabel', {
        defaultMessage: 'Analyze data drift without saving'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 389,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataDrift.indexPatternsEditor.analyzeDataDriftWithoutSavingLabel",
      defaultMessage: "Analyze data drift without saving",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 402,
        columnNumber: 21
      }
    }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 410,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: hasError,
      fill: true,
      onClick: createDataViewAndRedirectToDataDriftPage.bind(null, false),
      iconType: "visTagCloud",
      "data-test-subj": "analyzeDataDriftButton",
      "aria-label": _i18n.i18n.translate('xpack.ml.dataDrift.indexPatternsEditor.analyzeDataDriftLabel', {
        defaultMessage: 'Analyze data drift'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 411,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataDrift.indexPatternsEditor.analyzeDataDriftLabel",
      defaultMessage: "Analyze data drift",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 424,
        columnNumber: 19
      }
    }))))))
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: firstSetOfSteps,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 437,
      columnNumber: 10
    }
  });
}