"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useEditAction = exports.isEditActionFlyoutVisible = void 0;
var _react = _interopRequireWildcard(require("react"));
var _edit_action_name = require("./edit_action_name");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_management/components/action_edit/use_edit_action.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isEditActionFlyoutVisible = editAction => {
  return editAction.isFlyoutVisible === true && editAction.item !== undefined;
};
exports.isEditActionFlyoutVisible = isEditActionFlyoutVisible;
const useEditAction = canStartStopDataFrameAnalytics => {
  const [item, setItem] = (0, _react.useState)();
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const closeFlyout = () => setIsFlyoutVisible(false);
  const openFlyout = newItem => {
    setItem(newItem);
    setIsFlyoutVisible(true);
  };
  const action = (0, _react.useMemo)(() => ({
    name: () => /*#__PURE__*/_react.default.createElement(_edit_action_name.EditActionName, {
      isDisabled: !canStartStopDataFrameAnalytics,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 19
      }
    }),
    enabled: () => canStartStopDataFrameAnalytics,
    description: _edit_action_name.editActionNameText,
    icon: 'pencil',
    type: 'icon',
    onClick: i => openFlyout(i),
    'data-test-subj': 'mlAnalyticsJobEditButton'
  }), [canStartStopDataFrameAnalytics]);
  return {
    action,
    isFlyoutVisible,
    item,
    closeFlyout,
    openFlyout
  };
};
exports.useEditAction = useEditAction;