"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwitchModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/runtime_mappings/switch_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const modalTitle = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.runtimeEditorSwitchModalTitle', {
  defaultMessage: 'Edits will be lost'
});
const cancelButtonText = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.runtimeEditorSwitchModalCancelButtonText', {
  defaultMessage: 'Cancel'
});
const applyChangesText = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.runtimeEditorSwitchModalConfirmButtonText', {
  defaultMessage: 'Close editor'
});
const modalMessage = _i18n.i18n.translate('xpack.ml.dataframe.analytics.createWizard.runtimeEditorSwitchModalBodyText', {
  defaultMessage: `The changes in the editor haven't been applied yet. By closing the editor you will lose your edits.`
});
const SwitchModal = ({
  onCancel,
  onConfirm
}) => {
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: modalTitle,
    titleProps: {
      id: modalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: cancelButtonText,
    confirmButtonText: applyChangesText,
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, modalMessage));
};
exports.SwitchModal = SwitchModal;