"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigurationStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _configuration_step_details = require("./configuration_step_details");
var _configuration_step_form = require("./configuration_step_form");
var _page = require("../../page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/configuration_step/configuration_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfigurationStep = ({
  actions,
  state,
  setCurrentStep,
  step,
  stepActivated,
  isClone,
  sourceDataViewTitle
}) => {
  const showForm = step === _page.ANALYTICS_STEPS.CONFIGURATION;
  const showDetails = step !== _page.ANALYTICS_STEPS.CONFIGURATION && stepActivated === true;
  const dataTestSubj = `mlAnalyticsCreateJobWizardConfigurationStep${showForm ? ' active' : ''}${showDetails ? ' summary' : ''}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    className: "mlDataFrameAnalyticsCreateForm",
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, showForm && /*#__PURE__*/_react.default.createElement(_configuration_step_form.ConfigurationStepForm, {
    actions: actions,
    isClone: isClone,
    state: state,
    setCurrentStep: setCurrentStep,
    sourceDataViewTitle: sourceDataViewTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }), showDetails && /*#__PURE__*/_react.default.createElement(_configuration_step_details.ConfigurationStepDetails, {
    setCurrentStep: setCurrentStep,
    state: state,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 23
    }
  }));
};
exports.ConfigurationStep = ConfigurationStep;