"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StatsBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _stat = require("./stat");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/stats_bar/stats_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const StatsBar = ({
  stats,
  dataTestSub
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const statsList = Object.keys(stats).map(k => stats[k]);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: {
      padding: euiTheme.size.m,
      backgroundColor: euiTheme.colors.lightestShade
    },
    "data-test-subj": dataTestSub,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, statsList.filter(s => s.show).map(s => /*#__PURE__*/_react.default.createElement(_stat.Stat, {
    key: s.label,
    stat: s,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 11
    }
  })));
};
exports.StatsBar = StatsBar;