"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobSelectorFlyoutContent = exports.DEFAULT_GANTT_BAR_WIDTH = exports.BADGE_LIMIT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _new_selection_id_badges = require("./new_selection_id_badges");
var _job_selector_table = require("./job_selector_table");
var _job_select_service_utils = require("./job_select_service_utils");
var _kibana = require("../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/job_selector/job_selector_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-ignore
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BADGE_LIMIT = exports.BADGE_LIMIT = 10;
const DEFAULT_GANTT_BAR_WIDTH = exports.DEFAULT_GANTT_BAR_WIDTH = 299; // pixels

const JobSelectorFlyoutContent = ({
  dateFormatTz,
  selectedIds = [],
  singleSelection,
  timeseriesOnly,
  onJobsFetched,
  onSelectionConfirmed,
  onFlyoutClose,
  applyTimeRangeConfig: initialApplyTimeRangeConfig,
  onTimeRangeConfigChange,
  withTimeRangeSelector = true,
  flyoutTitleId = 'flyoutTitle'
}) => {
  const {
    services: {
      notifications,
      mlServices: {
        mlApi
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [newSelection, setNewSelection] = (0, _react.useState)(selectedIds);
  const [applyTimeRangeConfig, setApplyTimeRangeConfig] = (0, _react.useState)(initialApplyTimeRangeConfig !== null && initialApplyTimeRangeConfig !== void 0 ? initialApplyTimeRangeConfig : false);
  const [isLoading, setIsLoading] = (0, _react.useState)(true);
  const [showAllBadges, setShowAllBadges] = (0, _react.useState)(false);
  const [jobs, setJobs] = (0, _react.useState)([]);
  const [groups, setGroups] = (0, _react.useState)([]);
  const [ganttBarWidth, setGanttBarWidth] = (0, _react.useState)(DEFAULT_GANTT_BAR_WIDTH);
  const flyoutEl = (0, _react.useRef)(null);
  const applySelection = (0, _react.useCallback)(() => {
    const selectedGroupIds = newSelection.filter(id => groups.some(group => group.id === id));
    const jobsInSelectedGroups = [...new Set(groups.filter(group => selectedGroupIds.includes(group.id)).flatMap(group => group.jobIds))];
    const standaloneJobs = newSelection.filter(id => !selectedGroupIds.includes(id) && !jobsInSelectedGroups.includes(id));
    const finalSelection = [...selectedGroupIds, ...standaloneJobs];
    const time = applyTimeRangeConfig ? (0, _job_select_service_utils.getTimeRangeFromSelection)(jobs, finalSelection) : undefined;
    if (onTimeRangeConfigChange && initialApplyTimeRangeConfig !== applyTimeRangeConfig) {
      onTimeRangeConfigChange(applyTimeRangeConfig);
    }
    onSelectionConfirmed({
      newSelection: finalSelection,
      jobIds: finalSelection,
      time
    });
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [onSelectionConfirmed, newSelection, applyTimeRangeConfig]);
  function removeId(id) {
    setNewSelection(newSelection.filter(item => item !== id));
  }
  function toggleTimerangeSwitch() {
    setApplyTimeRangeConfig(prev => !prev);
  }
  function clearSelection() {
    setNewSelection([]);
  }
  function handleNewSelection({
    selectionFromTable
  }) {
    setNewSelection(selectionFromTable);
  }

  // Wrap handleResize in useCallback as it is a dependency for useEffect on line 131 below.
  // Not wrapping it would cause this dependency to change on every render
  const handleResize = (0, _react.useCallback)(() => {
    if (jobs.length === 0 || !flyoutEl.current) return;

    // get all cols in flyout table
    const tableHeaderCols = flyoutEl.current.querySelectorAll('table thead th');
    // get the width of the last col
    const derivedWidth = tableHeaderCols[tableHeaderCols.length - 1].offsetWidth - 16;
    const normalizedJobs = (0, _job_select_service_utils.normalizeTimes)(jobs, dateFormatTz, derivedWidth);
    setJobs(normalizedJobs);
    const {
      groups: updatedGroups
    } = (0, _job_select_service_utils.getGroupsFromJobs)(normalizedJobs);
    setGroups(updatedGroups);
    setGanttBarWidth(derivedWidth);
  }, [dateFormatTz, jobs]);

  // Fetch jobs list on flyout open
  (0, _react.useEffect)(() => {
    fetchJobs();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  async function fetchJobs() {
    try {
      const resp = await mlApi.jobs.jobsWithTimerange(dateFormatTz);
      const normalizedJobs = (0, _job_select_service_utils.normalizeTimes)(resp.jobs, dateFormatTz, DEFAULT_GANTT_BAR_WIDTH);
      const {
        groups: groupsWithTimerange,
        groupsMap
      } = (0, _job_select_service_utils.getGroupsFromJobs)(normalizedJobs);
      setJobs(normalizedJobs);
      setGroups(groupsWithTimerange);
      if (onJobsFetched) {
        onJobsFetched({
          groupsMap,
          jobsMap: resp.jobsMap
        });
      }
    } catch (e) {
      console.error('Error fetching jobs with time range', e); // eslint-disable-line no-console
      const {
        toasts
      } = notifications;
      toasts.addDanger({
        title: _i18n.i18n.translate('xpack.ml.jobSelector.jobFetchErrorMessage', {
          defaultMessage: 'An error occurred fetching jobs. Refresh and try again.'
        })
      });
    }
    setIsLoading(false);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.ml.jobSelector.flyoutTitle', {
    defaultMessage: 'Job selection'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": 'mlJobSelectorFlyoutBody',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiResizeObserver, {
    onResize: handleResize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 9
    }
  }, resizeRef => /*#__PURE__*/_react.default.createElement("div", {
    ref: e => {
      flyoutEl.current = e;
      resizeRef(e);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false,
    gutterSize: "xs",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_new_selection_id_badges.NewSelectionIdBadges, {
    limit: BADGE_LIMIT,
    groups: groups,
    newSelection: newSelection,
    onDeleteClick: removeId,
    onLinkClick: () => setShowAllBadges(!showAllBadges),
    showAllBadges: showAllBadges,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 25
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 25
    }
  }, !singleSelection && newSelection.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: clearSelection,
    size: "xs",
    "data-test-subj": "mlFlyoutJobSelectorButtonClearSelection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 29
    }
  }, _i18n.i18n.translate('xpack.ml.jobSelector.clearAllFlyoutButton', {
    defaultMessage: 'Clear all'
  }))), withTimeRangeSelector && jobs.length !== 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.ml.jobSelector.applyTimerangeSwitchLabel', {
      defaultMessage: 'Apply time range'
    }),
    checked: applyTimeRangeConfig,
    onChange: toggleTimerangeSwitch,
    "data-test-subj": "mlFlyoutJobSelectorSwitchApplyTimeRange",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 29
    }
  })) : null))), /*#__PURE__*/_react.default.createElement(_job_selector_table.JobSelectorTable, {
    jobs: jobs,
    ganttBarWidth: ganttBarWidth,
    groupsList: groups,
    onSelection: handleNewSelection,
    selectedIds: newSelection,
    singleSelection: singleSelection,
    timeseriesOnly: timeseriesOnly,
    withTimeRangeSelector: withTimeRangeSelector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 19
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: onFlyoutClose,
    "data-test-subj": "mlFlyoutJobSelectorButtonClose",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.ml.jobSelector.closeFlyoutButton', {
    defaultMessage: 'Close'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 11
    }
  }, jobs.length !== 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: applySelection,
    fill: true,
    isDisabled: newSelection.length === 0,
    "data-test-subj": "mlFlyoutJobSelectorButtonApply",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.ml.jobSelector.applyFlyoutButton', {
    defaultMessage: 'Apply'
  })) : null))));
};
exports.JobSelectorFlyoutContent = JobSelectorFlyoutContent;