"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupSelectorMenu = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _mlUrlState = require("@kbn/ml-url-state");
var _i18n = require("@kbn/i18n");
var _job_details_flyout_context = require("../../../jobs/components/job_details_flyout/job_details_flyout_context");
var _get_options_for_job_selector_menu = require("./get_options_for_job_selector_menu");
var _kibana = require("../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/job_selector/group_or_job_selector_menu/group_selector_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GroupSelectorMenu = ({
  groupId,
  jobIds,
  page,
  onRemoveJobId,
  removeJobIdDisabled,
  removeGroupDisabled,
  singleMetricViewerDisabledIds = []
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    setActiveFlyout,
    setActiveJobId
  } = (0, _job_details_flyout_context.useJobInfoFlyouts)();
  const {
    services: {
      share,
      application: {
        navigateToUrl
      }
    }
  } = (0, _kibana.useMlKibana)();
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const closePopover = () => setIsPopoverOpen(false);
  const onButtonClick = () => setIsPopoverOpen(true);
  const popoverId = `mlAnomalyGroupPopover-${groupId}`;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlJobSelectionBadge",
    iconType: "folderClosed",
    iconSide: "left",
    onClick: onButtonClick,
    size: "s",
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  }, groupId, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, jobIds.length));
  const panels = (0, _react.useMemo)(() => {
    const items = [{
      id: 0,
      items: [...jobIds.map((jobId, idx) => ({
        panel: jobId,
        name: jobId
      })), {
        isSeparator: true
      }, {
        name: _i18n.i18n.translate('xpack.ml.groupSelectorMenu.removeGroupLabel', {
          defaultMessage: 'Remove group from {page}',
          values: {
            page
          }
        }),
        icon: 'minusInCircle',
        disabled: removeGroupDisabled,
        onClick: () => {
          onRemoveJobId([groupId, ...jobIds]);
          closePopover();
        }
      }]
    }];
    jobIds.forEach(jobId => {
      const options = (0, _get_options_for_job_selector_menu.getOptionsForJobSelectorMenuItems)({
        jobId,
        page,
        onRemoveJobId,
        removeJobIdDisabled,
        showRemoveJobId: false,
        isSingleMetricViewerDisabled: singleMetricViewerDisabledIds.includes(jobId),
        closePopover,
        globalState,
        setActiveFlyout,
        setActiveJobId,
        navigateToUrl,
        share
      });
      const jobPanel = {
        id: jobId,
        title: jobId,
        items: options
      };
      items.push(jobPanel);
    });
    return items;
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobIds, setActiveFlyout, setActiveJobId,
  // eslint-disable-next-line react-hooks/exhaustive-deps
  JSON.stringify(globalState), navigateToUrl, share, page, onRemoveJobId, removeJobIdDisabled, removeGroupDisabled]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: popoverId,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }));
};
exports.GroupSelectorMenu = GroupSelectorMenu;