"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGlobalStorybookTheme = exports.decorateWithGlobalStorybookThemeProviders = exports.GlobalStorybookThemeProviders = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _common = require("@kbn/kibana-react-plugin/common");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/metrics_data_access/public/test_utils/use_global_storybook_theme.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useGlobalStorybookTheme = ({
  globals: {
    euiTheme
  }
}) => {
  const theme = (0, _react.useMemo)(() => euiThemeFromId(euiTheme), [euiTheme]);
  const [theme$] = (0, _react.useState)(() => new _rxjs.BehaviorSubject(theme));
  (0, _react.useEffect)(() => {
    theme$.next(theme);
  }, [theme$, theme]);
  return {
    theme,
    theme$
  };
};
exports.useGlobalStorybookTheme = useGlobalStorybookTheme;
const GlobalStorybookThemeProviders = ({
  children,
  storyContext
}) => {
  const {
    theme,
    theme$
  } = useGlobalStorybookTheme(storyContext);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: theme.darkMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, children));
};
exports.GlobalStorybookThemeProviders = GlobalStorybookThemeProviders;
const decorateWithGlobalStorybookThemeProviders = (wrappedStory, storyContext) => /*#__PURE__*/_react.default.createElement(GlobalStorybookThemeProviders, {
  storyContext: storyContext,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 3
  }
}, wrappedStory());
exports.decorateWithGlobalStorybookThemeProviders = decorateWithGlobalStorybookThemeProviders;
const euiThemeFromId = themeId => {
  switch (themeId) {
    case 'v8.dark':
      return {
        darkMode: true,
        name: 'amsterdam'
      };
    default:
      return {
        darkMode: false,
        name: 'amsterdam'
      };
  }
};