"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("../../_index.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _sharedUxButtonExitFullScreen = require("@kbn/shared-ux-button-exit-full-screen");
var _react2 = require("@emotion/react");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _mb_map = require("../mb_map");
var _right_side_controls = require("../right_side_controls");
var _timeslider = require("../timeslider");
var _toolbar_overlay = require("../toolbar_overlay");
var _edit_layer_panel = require("../edit_layer_panel");
var _add_layer_panel = require("../add_layer_panel");
var _kibana_services = require("../../kibana_services");
var _constants = require("../../../common/constants");
var _ui = require("../../reducers/ui");
var _map_settings_panel = require("../map_settings_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/map_container/map_container.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RENDER_COMPLETE_EVENT = 'renderComplete';
const mapWrapperStyles = (0, _react2.css)({
  position: 'relative'
});
class MapContainer extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_isInitalLoadRenderTimerStarted", false);
    (0, _defineProperty2.default)(this, "state", {
      isInitialLoadRenderTimeoutComplete: false,
      domId: (0, _uuid.v4)(),
      showFitToBoundsButton: false,
      showTimesliderButton: false
    });
    // Reporting uses both a `data-render-complete` attribute and a DOM event listener to determine
    // if a visualization is done loading. The process roughly is:
    // - See if the `data-render-complete` attribute is "true". If so we're done!
    // - If it's not, then reporting injects a listener into the browser for a custom "renderComplete" event.
    // - When that event is fired, we snapshot the viz and move on.
    // Failure to not have the dom attribute, or custom event, will timeout the job.
    // See x-pack/plugins/reporting/export_types/common/lib/screenshots/wait_for_render.ts for more.
    (0, _defineProperty2.default)(this, "_onInitialLoadRenderComplete", () => {
      const el = document.querySelector(`[data-dom-id="${this.state.domId}"]`);
      if (el) {
        el.dispatchEvent(new CustomEvent(RENDER_COMPLETE_EVENT, {
          bubbles: true
        }));
      }
    });
    (0, _defineProperty2.default)(this, "_startInitialLoadRenderTimer", () => {
      window.setTimeout(() => {
        if (this._isMounted) {
          this.setState({
            isInitialLoadRenderTimeoutComplete: true
          });
          this._onInitialLoadRenderComplete();
        }
      }, _constants.RENDER_TIMEOUT);
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadShowFitToBoundsButton();
    this._loadShowTimesliderButton();
  }
  componentDidUpdate() {
    this._loadShowFitToBoundsButton();
    this._loadShowTimesliderButton();
    if (this.props.isSharable && !this.props.isMapLoading && !this._isInitalLoadRenderTimerStarted) {
      this._isInitalLoadRenderTimerStarted = true;
      this._startInitialLoadRenderTimer();
    }
  }
  componentWillUnmount() {
    this._isMounted = false;
    this.props.cancelAllInFlightRequests();
  }
  async _loadShowFitToBoundsButton() {
    const promises = this.props.layerList.map(async layer => {
      return await layer.isFittable();
    });
    const showFitToBoundsButton = (await Promise.all(promises)).some(isFittable => isFittable);
    if (this._isMounted && this.state.showFitToBoundsButton !== showFitToBoundsButton) {
      this.setState({
        showFitToBoundsButton
      });
    }
  }
  async _loadShowTimesliderButton() {
    if (!this.props.settings.showTimesliderToggleButton) {
      if (this.state.showTimesliderButton) {
        this.setState({
          showTimesliderButton: false
        });
      }
      return;
    }
    const promises = this.props.layerList.map(async layer => {
      return await layer.isFilteredByGlobalTime();
    });
    const showTimesliderButton = (await Promise.all(promises)).some(isFilteredByGlobalTime => isFilteredByGlobalTime);
    if (this._isMounted && this.state.showTimesliderButton !== showTimesliderButton) {
      this.setState({
        showTimesliderButton
      });
    }
  }
  render() {
    const {
      addFilters,
      getFilterActions,
      getActionContext,
      onSingleValueTrigger,
      flyoutDisplay,
      isFullScreen,
      exitFullScreen,
      mapInitError,
      renderTooltipContent
    } = this.props;
    if (mapInitError) {
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-render-complete": true,
        "data-shared-item": true,
        "data-title": this.props.title,
        "data-description": this.props.description,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.maps.map.initializeErrorTitle', {
          defaultMessage: 'Unable to initialize map'
        }),
        color: "danger",
        iconType: "cross",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 13
        }
      }, mapInitError)));
    }
    let exitFullScreenButton;
    if (isFullScreen) {
      exitFullScreenButton = /*#__PURE__*/_react.default.createElement(_sharedUxButtonExitFullScreen.ExitFullScreenButton, {
        onExit: exitFullScreen,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 198,
          columnNumber: 30
        }
      });
    }
    const shareAttributes = this.props.isSharable ? {
      ['data-dom-id']: this.state.domId,
      ['data-render-complete']: this.state.isInitialLoadRenderTimeoutComplete,
      ['data-shared-item']: true,
      ['data-title']: this.props.title,
      ['data-description']: this.props.description
    } : {};
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
      gutterSize: "none",
      responsive: false
    }, shareAttributes, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: mapWrapperStyles,
      style: {
        backgroundColor: this.props.settings.backgroundColor
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_mb_map.MBMap, {
      addFilters: addFilters,
      getFilterActions: getFilterActions,
      getActionContext: getActionContext,
      onSingleValueTrigger: onSingleValueTrigger,
      renderTooltipContent: renderTooltipContent,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 11
      }
    }), !this.props.settings.hideToolbarOverlay && !(0, _kibana_services.isScreenshotMode)() && /*#__PURE__*/_react.default.createElement(_toolbar_overlay.ToolbarOverlay, {
      addFilters: addFilters,
      getFilterActions: getFilterActions,
      getActionContext: getActionContext,
      showFitToBoundsButton: this.state.showFitToBoundsButton,
      showTimesliderButton: this.state.showTimesliderButton,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_right_side_controls.RightSideControls, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 11
      }
    }), this.props.isTimesliderOpen && /*#__PURE__*/_react.default.createElement(_timeslider.Timeslider, {
      waitForTimesliceToLoad$: this.props.waitUntilTimeLayersLoad$,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(FlyoutPanelWrapper, {
      flyoutDisplay: flyoutDisplay,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 237,
        columnNumber: 9
      }
    }), exitFullScreenButton);
  }
}
exports.MapContainer = MapContainer;
const componentStyles = {
  flyoutPanelWrapperStyles: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.backgroundBaseSubdued,
    overflow: 'hidden',
    borderLeftWidth: 1,
    borderLeftColor: euiTheme.colors.borderBaseSubdued,
    borderLeftStyle: 'solid',
    width: 0,
    '& > *': {
      width: `calc(${euiTheme.size.xxl} * 12)`
    }
  }),
  flyoutVisibleStyles: ({
    euiTheme
  }) => (0, _react2.css)({
    width: `calc(${euiTheme.size.xxl} * 12)`,
    transition: `width ${euiTheme.animation.normal} ${euiTheme.animation.resistance}`
  })
};
const FlyoutPanelWrapper = ({
  flyoutDisplay
}) => {
  let flyoutPanel = null;
  if (flyoutDisplay === _ui.FLYOUT_STATE.ADD_LAYER_WIZARD) {
    flyoutPanel = /*#__PURE__*/_react.default.createElement(_add_layer_panel.AddLayerPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 267,
        columnNumber: 19
      }
    });
  } else if (flyoutDisplay === _ui.FLYOUT_STATE.LAYER_PANEL) {
    flyoutPanel = /*#__PURE__*/_react.default.createElement(_edit_layer_panel.EditLayerPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 269,
        columnNumber: 19
      }
    });
  } else if (flyoutDisplay === _ui.FLYOUT_STATE.MAP_SETTINGS_PANEL) {
    flyoutPanel = /*#__PURE__*/_react.default.createElement(_map_settings_panel.MapSettingsPanel, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 19
      }
    });
  }
  const isVisible = !!flyoutPanel;
  const styles = (0, _use_memo_css.useMemoCss)(componentStyles);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: [styles.flyoutPanelWrapperStyles, isVisible && styles.flyoutVisibleStyles],
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 5
    }
  }, flyoutPanel);
};