"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceDetails = SourceDetails;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/source_details/source_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function SourceDetails(props) {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [sourceProperties, setSourceProperties] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    let ignore = false;
    setIsLoading(true);
    props.source.getImmutableProperties(props.dataFilters).then(nextSourceProperties => {
      if (!ignore) {
        setSourceProperties(nextSourceProperties);
        setIsLoading(false);
      }
    });
    return () => {
      ignore = true;
    };
  }, [props.dataFilters, props.source]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "mapLayerPanel__sourceDetails",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "accordion1",
    buttonContent: _i18n.i18n.translate('xpack.maps.layerPanel.sourceDetailsLabel', {
      defaultMessage: 'Source details'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
    lines: 3,
    size: "s",
    isLoading: isLoading,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 11
    }
  }, sourceProperties.map(({
    label,
    value,
    link
  }) => {
    return /*#__PURE__*/_react.default.createElement("p", {
      key: label,
      className: "mapLayerPanel__sourceDetail",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 19
      }
    }, label), ' ', link ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: link,
      target: "_blank",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 21
      }
    }, value) : /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 21
      }
    }, value));
  })))));
}