"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TermJoinTooltipProperty = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _term_join_key_label = require("./term_join_key_label");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/tooltips/term_join_tooltip_property/term_join_tooltip_property.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class TermJoinTooltipProperty {
  constructor(tooltipProperty, termJoins) {
    (0, _defineProperty2.default)(this, "_tooltipProperty", void 0);
    (0, _defineProperty2.default)(this, "_termJoins", void 0);
    this._tooltipProperty = tooltipProperty;
    this._termJoins = termJoins;
  }
  isFilterable() {
    return true;
  }
  getPropertyKey() {
    return this._tooltipProperty.getPropertyKey();
  }
  getPropertyName() {
    return /*#__PURE__*/_react.default.createElement(_term_join_key_label.TermJoinKeyLabel, {
      leftFieldName: this._tooltipProperty.getPropertyName(),
      termJoins: this._termJoins,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 7
      }
    });
  }
  getRawValue() {
    return this._tooltipProperty.getRawValue();
  }
  getHtmlDisplayValue() {
    return this._tooltipProperty.getHtmlDisplayValue();
  }
  async getESFilters() {
    const esFilters = [];

    // only create filters for right sources.
    // do not create filters for left source.
    for (let i = 0; i < this._termJoins.length; i++) {
      const termField = this._termJoins[i].getTermField();
      try {
        const esTooltipProperty = await termField.createTooltipProperty(this._tooltipProperty.getRawValue());
        if (esTooltipProperty) {
          const filters = await esTooltipProperty.getESFilters();
          esFilters.push(...filters);
        }
      } catch (e) {
        // eslint-disable-next-line no-console
        console.error('Cannot create joined filter', e);
      }
    }
    return esFilters;
  }
}
exports.TermJoinTooltipProperty = TermJoinTooltipProperty;