"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.closeOnClickTooltip = closeOnClickTooltip;
exports.closeOnHoverTooltip = closeOnHoverTooltip;
exports.openOnClickTooltip = openOnClickTooltip;
exports.openOnHoverTooltip = openOnHoverTooltip;
exports.updateOpenTooltips = updateOpenTooltips;
var _lodash = _interopRequireDefault(require("lodash"));
var _map_selectors = require("../selectors/map_selectors");
var _map_action_constants = require("./map_action_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function closeOnClickTooltip(tooltipId) {
  return (dispatch, getState) => {
    dispatch({
      type: _map_action_constants.SET_OPEN_TOOLTIPS,
      openTooltips: (0, _map_selectors.getOpenTooltips)(getState()).filter(({
        id
      }) => {
        return tooltipId !== id;
      })
    });
  };
}
function openOnClickTooltip(tooltipState) {
  return (dispatch, getState) => {
    const openTooltips = (0, _map_selectors.getOpenTooltips)(getState()).filter(({
      features,
      location,
      isLocked
    }) => {
      return isLocked && !_lodash.default.isEqual(location, tooltipState.location) && !_lodash.default.isEqual(features.map(({
        id,
        layerId
      }) => {
        return {
          id,
          layerId
        };
      }), tooltipState.features.map(({
        id,
        layerId
      }) => {
        return {
          id,
          layerId
        };
      }));
    });
    openTooltips.push(tooltipState);
    dispatch({
      type: _map_action_constants.SET_OPEN_TOOLTIPS,
      openTooltips
    });
  };
}
function closeOnHoverTooltip() {
  return (dispatch, getState) => {
    if ((0, _map_selectors.getOpenTooltips)(getState()).length) {
      dispatch({
        type: _map_action_constants.SET_OPEN_TOOLTIPS,
        openTooltips: []
      });
    }
  };
}
function openOnHoverTooltip(tooltipState) {
  return {
    type: _map_action_constants.SET_OPEN_TOOLTIPS,
    openTooltips: [tooltipState]
  };
}
function updateOpenTooltips(openTooltips) {
  return {
    type: _map_action_constants.SET_OPEN_TOOLTIPS,
    openTooltips
  };
}