"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadFromLibrary = loadFromLibrary;
var _links_content_management_client = require("./links_content_management_client");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function loadFromLibrary(libraryId) {
  const {
    item
  } = await _links_content_management_client.linksClient.get(libraryId);
  if (item.error) {
    throw item.error;
  }
  return item.attributes;
}