"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfoBadge = InfoBadge;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/shared_components/info_badges/info_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function InfoBadge({
  title,
  dataView,
  index,
  palette,
  children,
  'data-test-subj-prefix': dataTestSubjPrefix
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const hasColor = Boolean(palette);
  const hasSingleColor = palette && palette.length === 1;
  const hasMultipleColors = palette && palette.length > 1;
  const iconType = hasSingleColor ? 'stopFilled' : 'color';
  return /*#__PURE__*/_react2.default.createElement("li", {
    key: `${title}-${dataView}-${index}`,
    "data-test-subj": `${dataTestSubjPrefix}-${index}`,
    css: (0, _react.css)`
        margin: ${euiTheme.size.base} 0 0;
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, hasColor ? /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    color: hasSingleColor ? palette[0] : undefined,
    type: iconType,
    "data-test-subj": `${dataTestSubjPrefix}-${index}-icon`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  })) : null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": `${dataTestSubjPrefix}-${index}-title`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 11
    }
  }, title)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, children)), hasMultipleColors ? /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            margin-top: ${euiTheme.size.xs};
            overflow-y: hidden;
            height: ${euiTheme.size.xs};
            margin-left: ${euiTheme.size.l};
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiColorPaletteDisplay, {
    size: "xs",
    palette: palette,
    "data-test-subj": `${dataTestSubjPrefix}-${index}-palette`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 11
    }
  })) : null);
}