"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticAgentCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _eui = require("@elastic/eui");
var _context = require("../../../context");
var _no_data_page = require("../no_data_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/kibana_react/public/page_template/no_data_page/no_data_card/elastic_agent_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Applies extra styling to a typical EuiAvatar
 */
const ElasticAgentCard = ({
  solution,
  recommended,
  title,
  href,
  button,
  layout,
  category,
  ...cardRest
}) => {
  const {
    services: {
      http,
      application
    }
  } = (0, _context.useKibana)();
  const addBasePath = http.basePath.prepend;
  const imageUrl = addBasePath(`/plugins/kibanaReact/assets/elastic_agent_card.svg`);
  const canAccessFleet = application.capabilities.navLinks.integrations;
  const hasCategory = category ? `/${category}` : '';
  const image = /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    size: "fullWidth",
    css: {
      width: 'max(100%, 360px)',
      height: 240,
      objectFit: 'cover',
      background: 'aliceblue'
    },
    url: imageUrl,
    alt: "",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
  if (!canAccessFleet) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      paddingSize: "l",
      image: image,
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "default",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('kibana-react.noDataPage.elasticAgentCard.noPermission.title', {
        defaultMessage: `Contact your administrator`
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "default",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('kibana-react.noDataPage.elasticAgentCard.noPermission.description', {
        defaultMessage: `This integration is not yet enabled. Your administrator has the required permissions to turn it on.`
      })),
      isDisabled: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 7
      }
    });
  }
  const defaultCTAtitle = _i18n.i18n.translate('kibana-react.noDataPage.elasticAgentCard.title', {
    defaultMessage: 'Add Elastic Agent'
  });
  const footer = typeof button !== 'string' && typeof button !== 'undefined' ? button :
  /*#__PURE__*/
  // The href and/or onClick are attached to the whole Card, so the button is just for show.
  // Do not add the behavior here too or else it will propogate through
  _react.default.createElement(_eui.EuiButton, {
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, button || title || defaultCTAtitle);
  return /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, (0, _extends2.default)({
    paddingSize: "l",
    image: image,
    href: href !== null && href !== void 0 ? href : addBasePath(`/app/integrations/browse${hasCategory}`)
    // Bad hack to fix the need for an a11y title even though the button exists
    ,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 13
      }
    }, defaultCTAtitle)),
    description: _i18n.i18n.translate('kibana-react.noDataPage.elasticAgentCard.description', {
      defaultMessage: `Use Elastic Agent for a simple, unified way to collect data from your machines.`
    }),
    betaBadgeProps: recommended ? {
      label: _no_data_page.NO_DATA_RECOMMENDED
    } : undefined,
    footer: footer,
    layout: layout
  }, cardRest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  })));
};
exports.ElasticAgentCard = ElasticAgentCard;