"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.interceptTriggerRecordSavedObject = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const interceptTriggerV1 = _configSchema.schema.object({
  firstRegisteredAt: _configSchema.schema.string(),
  /**
   * The interval at which the intercept should be displayed to the user.
   */
  triggerAfter: _configSchema.schema.string(),
  /**
   * The version of kibana where this intercept trigger was installed.
   */
  installedOn: _configSchema.schema.string(),
  /**
   * Flag to denote if the trigger should run in perpetuity or not. set to false for a trigger that should run only once.
   */
  recurrent: _configSchema.schema.boolean()
});
const interceptTriggerProperties = {
  firstRegisteredAt: {
    type: 'date'
  },
  triggerAfter: {
    type: 'text'
  },
  installedOn: {
    type: 'keyword'
  },
  recurrent: {
    type: 'boolean'
  }
};
const interceptTriggerRecordSavedObject = exports.interceptTriggerRecordSavedObject = {
  name: 'intercept_trigger_record',
  hidden: true,
  hiddenFromHttpApis: true,
  namespaceType: 'agnostic',
  mappings: {
    dynamic: false,
    properties: interceptTriggerProperties
  },
  modelVersions: {
    1: {
      changes: [],
      schemas: {
        forwardCompatibility: interceptTriggerV1.extends({}, {
          unknowns: 'ignore'
        }),
        create: interceptTriggerV1
      }
    }
  }
};