"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesCreate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _navigation = require("../../services/navigation");
var _shared_imports = require("../../../shared_imports");
var _components = require("../../components");
var _hooks = require("../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/sections/pipelines_create/pipelines_create.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function useFormDefaultValue(sourcePipeline) {
  const history = (0, _reactRouterDom.useHistory)();
  const locationSearchParams = (0, _react.useMemo)(() => {
    // Note:
    // No need to decode the search params as URLSearchParams
    // does that automatically upon reading them
    //
    // For the context on why this note exists
    // see: https://github.com/elastic/kibana/issues/234500
    return new URLSearchParams(history.location.search);
  }, [history.location.search]);
  const formDefaultValue = (0, _react.useMemo)(() => {
    var _history$location$sta;
    if (sourcePipeline) {
      return sourcePipeline;
    }
    if ((_history$location$sta = history.location.state) !== null && _history$location$sta !== void 0 && _history$location$sta.sourcePipeline) {
      return history.location.state.sourcePipeline;
    }
    if (locationSearchParams.has('name')) {
      return {
        name: locationSearchParams.get('name'),
        description: '',
        processors: [],
        on_failure: []
      };
    }
  }, [sourcePipeline, history, locationSearchParams]);
  return {
    formDefaultValue,
    canEditName: !locationSearchParams.has('name')
  };
}
const PipelinesCreate = ({
  sourcePipeline
}) => {
  var _services$consolePlug;
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const [isSaving, setIsSaving] = (0, _react.useState)(false);
  const [saveError, setSaveError] = (0, _react.useState)(null);
  const {
    formDefaultValue,
    canEditName
  } = useFormDefaultValue(sourcePipeline);
  const redirectToPathOrRedirectPath = (0, _hooks.useRedirectToPathOrRedirectPath)(history);
  const onSave = async pipeline => {
    setIsSaving(true);
    setSaveError(null);
    const {
      error
    } = await services.api.createPipeline(pipeline);
    setIsSaving(false);
    if (error) {
      setSaveError(error);
      return;
    }
    redirectToPathOrRedirectPath((0, _navigation.getListPath)({
      inspectedPipelineName: pipeline.name
    }));
  };
  const onCancel = () => redirectToPathOrRedirectPath((0, _navigation.getListPath)());
  (0, _react.useEffect)(() => {
    services.breadcrumbs.setBreadcrumbs('create');
  }, [services]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "pageTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.create.pageTitle",
      defaultMessage: "Create pipeline",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 13
      }
    })),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      flush: "right",
      href: services.documentation.getCreatePipelineUrl(),
      target: "_blank",
      iconType: "question",
      "data-test-subj": "documentationLink",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.create.docsButtonLabel",
      defaultMessage: "Create pipeline docs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 13
      }
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_components.PipelineForm, {
    defaultValue: formDefaultValue,
    canEditName: canEditName,
    onSave: onSave,
    onCancel: onCancel,
    isSaving: isSaving,
    saveError: saveError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }), (_services$consolePlug = services.consolePlugin) !== null && _services$consolePlug !== void 0 && _services$consolePlug.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(services.consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }) : null);
};
exports.PipelinesCreate = PipelinesCreate;