"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToNodeDetails = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _datemath = require("@kbn/datemath");
var _public = require("@kbn/metrics-data-access-plugin/public");
var _use_asset_details_url_state = require("../hooks/use_asset_details_url_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/links/link_to_node_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LinkToNodeDetails = ({
  entityId,
  entityName,
  entityType
}) => {
  var _parse, _dateRange$from, _parse2, _dateRange$to;
  const [state] = (0, _use_asset_details_url_state.useAssetDetailsUrlState)();
  const {
    getAssetDetailUrl
  } = (0, _public.useAssetDetailsRedirect)();

  // don't propagate the autoRefresh to the details page
  const {
    dateRange,
    autoRefresh: _,
    preferredSchema,
    ...assetDetails
  } = state !== null && state !== void 0 ? state : {};
  const assetDetailMenuItemLinkProps = getAssetDetailUrl({
    entityType,
    entityId,
    search: {
      ...assetDetails,
      name: entityName,
      from: (_parse = (0, _datemath.parse)((_dateRange$from = dateRange === null || dateRange === void 0 ? void 0 : dateRange.from) !== null && _dateRange$from !== void 0 ? _dateRange$from : '')) === null || _parse === void 0 ? void 0 : _parse.valueOf(),
      to: (_parse2 = (0, _datemath.parse)((_dateRange$to = dateRange === null || dateRange === void 0 ? void 0 : dateRange.to) !== null && _dateRange$to !== void 0 ? _dateRange$to : '')) === null || _parse2 === void 0 ? void 0 : _parse2.valueOf()
    },
    preferredSchema: preferredSchema !== null && preferredSchema !== void 0 ? preferredSchema : 'semconv'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({
    "aria-label": _i18n.i18n.translate('xpack.infra.linkToNodeDetails.openaspageButton.ariaLabel', {
      defaultMessage: 'Open as page'
    }),
    "data-test-subj": "infraAssetDetailsOpenAsPageButton",
    size: "xs",
    flush: "both"
  }, assetDetailMenuItemLinkProps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.infra.nodeDetails.openAsPage",
    defaultMessage: "Open as page",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }));
};
exports.LinkToNodeDetails = LinkToNodeDetails;