"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StepLogistics = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../shared_imports");
var _shared = require("../../../../shared");
var _component_templates_context = require("../../../component_templates_context");
var _step_logistics_schema = require("./step_logistics_schema");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/component_templates/component_template_wizard/component_template_form/steps/step_logistics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const FormRow = (0, _shared_imports.getFormRow)({
  titleTag: 'h3'
});
const StepLogistics = exports.StepLogistics = /*#__PURE__*/_react.default.memo(({
  defaultValue,
  isEditing,
  onChange
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: _step_logistics_schema.logisticsFormSchema,
    defaultValue,
    options: {
      stripEmptyFields: false
    }
  });
  const {
    isValid: isFormValid,
    submit,
    getFormData,
    subscribe
  } = form;
  const [{
    lifecycle
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['lifecycle.enabled', 'lifecycle.infiniteDataRetention']
  });
  const {
    documentation
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const [isMetaVisible, setIsMetaVisible] = (0, _react.useState)(Boolean(defaultValue._meta && Object.keys(defaultValue._meta).length));
  const validate = (0, _react.useCallback)(async () => {
    return (await submit()).isValid;
  }, [submit]);
  (0, _react.useEffect)(() => {
    onChange({
      isValid: isFormValid,
      validate,
      getData: getFormData
    });
  }, [isFormValid, getFormData, validate, onChange]);
  (0, _react.useEffect)(() => {
    const subscription = subscribe(({
      data,
      isValid
    }) => {
      onChange({
        isValid,
        validate,
        getData: data.format
      });
    });
    return subscription.unsubscribe;
  }, [subscribe, validate, onChange]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form,
    "data-test-subj": "stepLogistics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.stepTitle",
    defaultMessage: "Logistics",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    flush: "right",
    href: documentation.componentTemplates,
    target: "_blank",
    iconType: "question",
    "data-test-subj": "documentationLink",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.docsButtonLabel",
    defaultMessage: "Component Templates docs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.nameTitle",
      defaultMessage: "Name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 13
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.nameDescription",
      defaultMessage: "Unique name for this component template.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "name",
    componentProps: {
      ['data-test-subj']: 'nameField',
      euiFieldProps: {
        disabled: isEditing
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.dataRetentionTitle",
      defaultMessage: "Data retention",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 13
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.dataRetentionDescription",
      defaultMessage: "Data will be kept at least this long before being automatically deleted.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(UseField, {
      path: "lifecycle.enabled",
      componentProps: {
        'data-test-subj': 'dataRetentionToggle'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, (lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.enabled) && /*#__PURE__*/_react.default.createElement(UseField, {
    path: "lifecycle.value",
    component: _shared_imports.NumericField,
    labelAppend: /*#__PURE__*/_react.default.createElement(UseField, {
      path: "lifecycle.infiniteDataRetention",
      "data-test-subj": "infiniteDataRetentionToggle",
      componentProps: {
        euiFieldProps: {
          compressed: true
        }
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 175,
        columnNumber: 17
      }
    }),
    componentProps: {
      euiFieldProps: {
        disabled: lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.infiniteDataRetention,
        'data-test-subj': 'valueDataRetentionField',
        min: 1,
        append: /*#__PURE__*/_react.default.createElement(_shared.UnitField, {
          path: "lifecycle.unit",
          options: _shared.timeUnits,
          disabled: lifecycle === null || lifecycle === void 0 ? void 0 : lifecycle.infiniteDataRetention,
          euiFieldProps: {
            'data-test-subj': 'unitDataRetentionField'
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 191,
            columnNumber: 21
          }
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.versionTitle",
      defaultMessage: "Version",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 13
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.versionDescription",
      defaultMessage: "Number used by external management systems to identify the component template.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 215,
        columnNumber: 13
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(UseField, {
    path: "version",
    componentProps: {
      ['data-test-subj']: 'versionField'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(FormRow, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.metaTitle",
      defaultMessage: "Metadata",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 232,
        columnNumber: 13
      }
    }),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.metaDescription",
      defaultMessage: "Arbitrary information about the template, stored in the cluster state. {learnMoreLink}",
      values: {
        learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: documentation.componentTemplatesMetadata,
          target: "_blank",
          external: true,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 244,
            columnNumber: 21
          }
        }, _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.stepLogistics.metaDocumentionLink', {
          defaultMessage: 'Learn more.'
        }))
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 260,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.metadataDescription",
        defaultMessage: "Add metadata",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 264,
          columnNumber: 19
        }
      }),
      checked: isMetaVisible,
      onChange: e => setIsMetaVisible(e.target.checked),
      "data-test-subj": "metaToggle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 262,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 9
    }
  }, isMetaVisible && /*#__PURE__*/_react.default.createElement(UseField, {
    path: "_meta",
    component: _shared_imports.JsonEditorField,
    componentProps: {
      codeEditorProps: {
        ['data-test-subj']: 'metaEditor',
        height: '200px',
        'aria-label': _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.stepLogistics.metaAriaLabel', {
          defaultMessage: '_meta field data editor'
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 13
    }
  })));
});