"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAvailableNodeRoleForPhase = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Given a phase and current cluster node roles, determine which nodes the phase
 * will allocate data to. For instance, for the warm phase, with warm
 * tier nodes, we would expect "data_warm".
 *
 * If no nodes can be identified for allocation (very special case) then
 * we return "none".
 */
const getAvailableNodeRoleForPhase = (phase, nodesByRoles) => {
  var _nodesByRoles$data;
  const preferredNodeRoles = _constants.phaseToNodePreferenceMap[phase];

  // The 'data' role covers all node roles, so if we have at least one node with the data role
  // we can allocate to our first preference.
  if ((_nodesByRoles$data = nodesByRoles.data) !== null && _nodesByRoles$data !== void 0 && _nodesByRoles$data.length) {
    return preferredNodeRoles[0];
  }
  return preferredNodeRoles.find(role => {
    var _nodesByRoles$role;
    return Boolean((_nodesByRoles$role = nodesByRoles[role]) === null || _nodesByRoles$role === void 0 ? void 0 : _nodesByRoles$role.length);
  });
};
exports.getAvailableNodeRoleForPhase = getAvailableNodeRoleForPhase;