"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmModalProvider = void 0;
exports.useConfirmModal = useConfirmModal;
exports.withConfirmModalProvider = withConfirmModalProvider;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/hooks/use_confirm_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ModalContext = /*#__PURE__*/_react.default.createContext(null);
function useConfirmModal() {
  const context = (0, _react.useContext)(ModalContext);
  const confirm = (0, _react.useCallback)(async (title, description, options) => {
    if (context === null) {
      throw new Error('Context need to be provided to use useConfirmModal');
    }
    return new Promise(resolve => {
      context.showModal({
        title,
        description,
        onConfirm: () => resolve(true),
        onCancel: () => resolve(false),
        options
      });
    });
  }, [context]);
  return {
    confirm
  };
}
function withConfirmModalProvider(WrappedComponent) {
  return props => /*#__PURE__*/_react.default.createElement(ConfirmModalProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(WrappedComponent, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  })));
}
const ConfirmModalProvider = ({
  children
}) => {
  var _modal$options, _modal$options$confir, _modal$options2;
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const [modal, setModal] = (0, _react.useState)({
    onCancel: () => {},
    onConfirm: () => {}
  });
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const showModal = (0, _react.useCallback)(({
    title,
    description,
    onConfirm,
    onCancel,
    options
  }) => {
    setIsVisible(true);
    setModal({
      title,
      description,
      onConfirm: () => {
        setIsVisible(false);
        onConfirm();
      },
      onCancel: () => {
        setIsVisible(false);
        onCancel();
      },
      options
    });
  }, []);
  return /*#__PURE__*/_react.default.createElement(ModalContext.Provider, {
    value: {
      showModal
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, isVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: modal.title,
    titleProps: {
      id: confirmModalTitleId
    },
    buttonColor: (_modal$options = modal.options) === null || _modal$options === void 0 ? void 0 : _modal$options.buttonColor,
    onCancel: modal.onCancel,
    onConfirm: modal.onConfirm,
    cancelButtonText: _i18n.i18n.translate('xpack.fleet.settings.confirmModal.cancelButtonText', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: (_modal$options$confir = (_modal$options2 = modal.options) === null || _modal$options2 === void 0 ? void 0 : _modal$options2.confirmButtonText) !== null && _modal$options$confir !== void 0 ? _modal$options$confir : _i18n.i18n.translate('xpack.fleet.settings.confirmModal.confirmButtonText', {
      defaultMessage: 'Save and deploy'
    }),
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, modal.description)), children);
};
exports.ConfirmModalProvider = ConfirmModalProvider;