"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetProxiesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/fleet_proxies_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NameFlexItemWithMaxWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 250px;
`;
const FleetProxiesTable = ({
  proxies,
  deleteFleetProxy
}) => {
  const authz = (0, _hooks.useAuthz)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const columns = (0, _react.useMemo)(() => {
    return [{
      render: fleetProxy => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 37,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(NameFlexItemWithMaxWidth, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 38,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        title: fleetProxy.name,
        className: `eui-textTruncate`,
        "data-test-subj": "fleetProxiesTable.name",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 15
        }
      }, fleetProxy.name)), fleetProxy.is_preconfigured && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 48,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.fleet.settings.fleetProxiesTable.managedTooltip', {
          defaultMessage: 'This proxy is managed outside of Fleet. Please refer to your kibana config file for more info.'
        }),
        type: "lock",
        size: "m",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 17
        }
      }))),
      width: '288px',
      name: _i18n.i18n.translate('xpack.fleet.settings.fleetProxiesTable.nameColumnTitle', {
        defaultMessage: 'Name'
      })
    }, {
      truncateText: true,
      field: 'url',
      name: _i18n.i18n.translate('xpack.fleet.settings.fleetProxiesTable.urlColumnTitle', {
        defaultMessage: 'Url'
      })
    }, {
      width: '68px',
      render: fleetProxy => {
        const isDeleteVisible = authz.fleet.allSettings && !fleetProxy.is_preconfigured;
        const deleteButtonLabel = _i18n.i18n.translate('xpack.fleet.settings.fleetProxiesTable.deleteButtonTitle', {
          defaultMessage: 'Delete'
        });
        const editButtonLabel = _i18n.i18n.translate('xpack.fleet.settings.fleetProxiesTable.editButtonTitle', {
          defaultMessage: 'Edit'
        });
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          justifyContent: "flexEnd",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 92,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 93,
            columnNumber: 15
          }
        }, isDeleteVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "aria-label": deleteButtonLabel,
          color: "text",
          iconType: "trash",
          onClick: () => deleteFleetProxy(fleetProxy),
          title: deleteButtonLabel,
          "data-test-subj": "fleetProxiesTable.delete.btn",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 95,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 105,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          "aria-label": editButtonLabel,
          color: "text",
          iconType: "pencil",
          href: getHref('settings_edit_fleet_proxy', {
            itemId: fleetProxy.id
          }),
          title: editButtonLabel,
          "data-test-subj": "fleetProxiesTable.edit.btn",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 106,
            columnNumber: 17
          }
        })));
      },
      name: _i18n.i18n.translate('xpack.fleet.settings.fleetProxiesTable.actionsColumnTitle', {
        defaultMessage: 'Actions'
      })
    }];
  }, [deleteFleetProxy, getHref, authz.fleet.allSettings]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: proxies,
    "data-test-subj": "fleetProxiesTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 10
    }
  });
};
exports.FleetProxiesTable = FleetProxiesTable;