"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentDetailsPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../constants");
var _components = require("../../../components");
var _hooks = require("../../../hooks");
var _layouts = require("../../../layouts");
var _components2 = require("../agent_list_page/components");
var _hooks2 = require("./hooks");
var _components3 = require("./components");
var _agent_settings = require("./components/agent_settings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_details_page/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AgentDetailsPage = () => {
  var _agentData$item, _agent$local_metadata, _agent$tags;
  const {
    params: {
      agentId,
      tabId = ''
    }
  } = (0, _reactRouterDom.useRouteMatch)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const {
    showAgentless
  } = (0, _hooks.useAgentlessResources)();
  const {
    isLoading,
    isInitialRequest,
    error,
    data: agentData,
    resendRequest: sendAgentRequest
  } = (0, _hooks.useGetOneAgent)(agentId, {
    pollIntervalMs: 5000,
    query: {
      withMetrics: true
    }
  });
  const {
    isLoading: isAgentPolicyLoading,
    data: agentPolicyData,
    sendRequest: sendAgentPolicyRequest
  } = (0, _hooks.useGetOneAgentPolicy)(agentData === null || agentData === void 0 ? void 0 : (_agentData$item = agentData.item) === null || _agentData$item === void 0 ? void 0 : _agentData$item.policy_id);
  const {
    application: {
      navigateToApp
    },
    notifications
  } = (0, _hooks.useStartServices)();
  const routeState = (0, _hooks.useIntraAppState)();
  const queryParams = new URLSearchParams((0, _reactRouterDom.useLocation)().search);
  const openReassignFlyoutOpenByDefault = queryParams.get('openReassignFlyout') === 'true';
  const reassignCancelClickHandler = (0, _react.useCallback)(() => {
    if (routeState && routeState.onDoneNavigateTo) {
      navigateToApp(routeState.onDoneNavigateTo[0], routeState.onDoneNavigateTo[1]);
    }
  }, [routeState, navigateToApp]);
  const isAgentlessAgent = agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.item.supports_agentless;
  const agent = agentData !== null && agentData !== void 0 && agentData.item && (isAgentlessAgent ? showAgentless : true) ? agentData.item : null;
  const host = agent && ((_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : _agent$local_metadata.host);
  const headerLeftContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    href: getHref('agent_list'),
    flush: "left",
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentDetails.viewAgentListTitle",
    defaultMessage: "View all agents",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }, isLoading && isInitialRequest ? /*#__PURE__*/_react.default.createElement(_components.Loading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 17
    }
  }) : typeof host === 'object' && typeof (host === null || host === void 0 ? void 0 : host.hostname) === 'string' ? host.hostname : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentDetails.agentDetailsTitle",
    defaultMessage: "Agent ''{id}''",
    values: {
      id: agentId
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  }))))), [host, agentId, getHref, isInitialRequest, isLoading]);
  const [tagsPopoverButton, setTagsPopoverButton] = (0, _react.useState)();
  const [showTagsAddRemove, setShowTagsAddRemove] = (0, _react.useState)(false);
  const [allTags, setAllTags] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    // Fetch all tags when the component mounts
    const fetchTags = async () => {
      try {
        var _agentTagsResponse$da, _agentTagsResponse$da2;
        const agentTagsResponse = await (0, _hooks.sendGetAgentTags)({
          showInactive: (agent === null || agent === void 0 ? void 0 : agent.status) === 'inactive'
        });
        if (agentTagsResponse.error) {
          throw agentTagsResponse.error;
        }
        const newAllTags = (_agentTagsResponse$da = agentTagsResponse === null || agentTagsResponse === void 0 ? void 0 : (_agentTagsResponse$da2 = agentTagsResponse.data) === null || _agentTagsResponse$da2 === void 0 ? void 0 : _agentTagsResponse$da2.items) !== null && _agentTagsResponse$da !== void 0 ? _agentTagsResponse$da : [];
        setAllTags(newAllTags);
      } catch (err) {
        notifications.toasts.addError(err, {
          title: _i18n.i18n.translate('xpack.fleet.agentList.errorFetchingTagsTitle', {
            defaultMessage: 'Error fetching tags'
          })
        });
      }
    };
    if (agent !== null && agent !== void 0 && agent.active) {
      fetchTags();
    }
  }, [setAllTags, notifications, agent]);
  const headerRightContent = (0, _react.useMemo)(() => agent ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "s",
    direction: "row",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, !isAgentPolicyLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 158,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_components3.AgentDetailsActionMenu, {
    agent: agent,
    agentPolicy: agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.item,
    assignFlyoutOpenByDefault: openReassignFlyoutOpenByDefault,
    onCancelReassign: routeState && routeState.onDoneNavigateTo ? reassignCancelClickHandler : undefined,
    onAddRemoveTagsClick: button => {
      setTagsPopoverButton(button);
      setShowTagsAddRemove(!showTagsAddRemove);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 17
    }
  })))) : undefined, /* eslint-disable-next-line react-hooks/exhaustive-deps */
  [agentPolicyData, agentData, getHref, isAgentPolicyLoading]);
  const headerTabs = (0, _react.useMemo)(() => {
    const tabs = [{
      id: 'details',
      name: _i18n.i18n.translate('xpack.fleet.agentDetails.subTabs.detailsTab', {
        defaultMessage: 'Agent details'
      }),
      href: getHref('agent_details', {
        agentId,
        tabId: 'details'
      }),
      isSelected: !tabId || tabId === 'details'
    }, {
      id: 'logs',
      name: _i18n.i18n.translate('xpack.fleet.agentDetails.subTabs.logsTab', {
        defaultMessage: 'Logs'
      }),
      href: getHref('agent_details_logs', {
        agentId,
        tabId: 'logs'
      }),
      isSelected: tabId === 'logs'
    }, {
      id: 'diagnostics',
      name: _i18n.i18n.translate('xpack.fleet.agentDetails.subTabs.diagnosticsTab', {
        defaultMessage: 'Diagnostics'
      }),
      href: getHref('agent_details_diagnostics', {
        agentId,
        tabId: 'diagnostics'
      }),
      isSelected: tabId === 'diagnostics'
    }, {
      id: 'settings',
      name: _i18n.i18n.translate('xpack.fleet.agentDetails.subTabs.settingsTab', {
        defaultMessage: 'Settings'
      }),
      href: getHref('agent_details_settings', {
        agentId,
        tabId: 'settings'
      }),
      isSelected: tabId === 'settings'
    }];
    return tabs;
  }, [getHref, agentId, tabId]);
  return /*#__PURE__*/_react.default.createElement(_hooks2.AgentRefreshContext.Provider, {
    value: {
      refresh: () => {
        sendAgentRequest();
        sendAgentPolicyRequest();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_layouts.WithHeaderLayout, {
    leftColumn: headerLeftContent,
    rightColumn: headerRightContent,
    tabs: headerTabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }, isLoading && isInitialRequest ? /*#__PURE__*/_react.default.createElement(_components.Loading, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  }) : error ? /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentDetails.unexceptedErrorTitle",
      defaultMessage: "Error loading agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 239,
        columnNumber: 15
      }
    }),
    error: error,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 11
    }
  }) : agent ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(AgentDetailsPageContent, {
    agent: agent,
    agentPolicy: agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.item,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 13
    }
  }), showTagsAddRemove && /*#__PURE__*/_react.default.createElement(_components2.TagsAddRemove, {
    agentId: agent === null || agent === void 0 ? void 0 : agent.id,
    allTags: allTags !== null && allTags !== void 0 ? allTags : [],
    selectedTags: (_agent$tags = agent === null || agent === void 0 ? void 0 : agent.tags) !== null && _agent$tags !== void 0 ? _agent$tags : [],
    button: tagsPopoverButton,
    onTagsUpdated: tagsToAdd => {
      sendAgentRequest();
      if (tagsToAdd.length > 0) {
        setAllTags([...new Set([...(allTags !== null && allTags !== void 0 ? allTags : []), ...tagsToAdd])].sort());
      }
    },
    onClosePopover: () => {
      setShowTagsAddRemove(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_components.Error, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentDetails.agentNotFoundErrorTitle",
      defaultMessage: "Agent not found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 15
      }
    }),
    error: _i18n.i18n.translate('xpack.fleet.agentDetails.agentNotFoundErrorDescription', {
      defaultMessage: 'Cannot find agent ID {agentId}',
      values: {
        agentId
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 11
    }
  })));
};
exports.AgentDetailsPage = AgentDetailsPage;
const AgentDetailsPageContent = ({
  agent,
  agentPolicy
}) => {
  (0, _hooks.useBreadcrumbs)('agent_details', {
    agentHost: typeof agent.local_metadata.host === 'object' && typeof agent.local_metadata.host.hostname === 'string' ? agent.local_metadata.host.hostname : '-'
  });
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.agent_details_logs,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_components3.AgentLogs, {
        agent: agent,
        agentPolicy: agentPolicy,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 304,
          columnNumber: 18
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.agent_details_diagnostics,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_components3.AgentDiagnosticsTab, {
        agent: agent,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 310,
          columnNumber: 18
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.agent_details_settings,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_agent_settings.AgentSettings, {
        agent: agent,
        agentPolicy: agentPolicy,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 316,
          columnNumber: 18
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.FLEET_ROUTING_PATHS.agent_details,
    render: () => {
      return /*#__PURE__*/_react.default.createElement(_components3.AgentDetailsContent, {
        agent: agent,
        agentPolicy: agentPolicy,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 322,
          columnNumber: 18
        }
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 7
    }
  }));
};