"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricVis = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _charts = require("@elastic/charts");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _constants = require("../../common/constants");
var _services = require("../services");
var _helpers = require("./helpers");
var _secondary_metric_info = require("./secondary_metric_info");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_metric/public/components/metric_vis.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const buildFilterEvent = (rowIdx, columnIdx, table) => {
  const column = table.columns[columnIdx];
  return {
    name: 'filter',
    data: {
      data: [{
        table,
        column: columnIdx,
        row: rowIdx,
        value: table.rows[rowIdx][column.id]
      }]
    }
  };
};
const getIcon = type => ({
  width,
  height,
  color
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: type,
  fill: color,
  css: {
    width,
    height
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 63,
    columnNumber: 5
  }
});
function buildTrendConfig({
  palette,
  visuals,
  baseline
}, value) {
  if (!palette) return undefined;
  return {
    showIcon: visuals !== 'value',
    showValue: visuals !== 'icon',
    baselineValue: baseline === 'primary' && typeof value === 'number' ? value : Number(baseline),
    palette,
    borderColor: undefined,
    compareToPrimary: baseline === 'primary'
  };
}
const DEFAULT_TILE_SIDE_LENGTH = 310;
const MetricVis = ({
  data,
  config,
  renderComplete,
  fireEvent,
  filterable,
  overrides
}) => {
  var _getColumnByAccessor;
  const grid = (0, _react.useRef)([[]]);
  const {
    euiTheme: {
      colors
    },
    highContrastMode
  } = (0, _eui.useEuiTheme)();
  const defaultColor = colors.emptyShade;
  const onRenderChange = (0, _react.useCallback)(isRendered => {
    if (isRendered) {
      renderComplete();
    }
  }, [renderComplete]);
  const onWillRender = (0, _react.useCallback)(() => {
    var _grid$current$, _grid$current$2;
    const maxTileSideLength = grid.current.length * ((_grid$current$ = grid.current[0]) === null || _grid$current$ === void 0 ? void 0 : _grid$current$.length) > 1 ? 200 : DEFAULT_TILE_SIDE_LENGTH;
    const event = {
      name: 'chartSize',
      data: {
        maxDimensions: {
          y: {
            value: grid.current.length * maxTileSideLength,
            unit: 'pixels'
          },
          x: {
            value: ((_grid$current$2 = grid.current[0]) === null || _grid$current$2 === void 0 ? void 0 : _grid$current$2.length) * maxTileSideLength,
            unit: 'pixels'
          }
        }
      }
    };
    fireEvent(event);
  }, [fireEvent, grid]);
  const [scrollChildHeight, setScrollChildHeight] = (0, _react.useState)('100%');
  const scrollContainerRef = (0, _react.useRef)(null);
  const scrollDimensions = (0, _eui.useResizeObserver)(scrollContainerRef.current);
  const chartBaseTheme = (0, _services.getThemeService)().useChartsBaseTheme();
  const primaryMetricColumn = (0, _utils.getColumnByAccessor)(config.dimensions.metric, data.columns);
  const formatPrimaryMetric = (0, _react.useMemo)(() => (0, _helpers.getMetricFormatter)(config.dimensions.metric, data.columns), [config.dimensions.metric, data.columns]);
  let breakdownByColumn;
  let formatBreakdownValue;
  if (config.dimensions.breakdownBy) {
    breakdownByColumn = (0, _utils.getColumnByAccessor)(config.dimensions.breakdownBy, data.columns);
    formatBreakdownValue = (0, _services.getFormatService)().deserialize((0, _utils.getFormatByAccessor)(config.dimensions.breakdownBy, data.columns)).getConverterFor('text');
  }
  const maxColId = config.dimensions.max ? (_getColumnByAccessor = (0, _utils.getColumnByAccessor)(config.dimensions.max, data.columns)) === null || _getColumnByAccessor === void 0 ? void 0 : _getColumnByAccessor.id : undefined;

  // For a sigle tile configuration, either no breakdown or with a collapse by, provide
  // a fallback in case of missing data. Make sure to provide an exact "null" value to render a N/A metric.
  // For reference, undefined will render as - instead of N/A and it is used in a breakdown scenario
  const firstRowForNonBreakdown = (data.rows.length ? data.rows : [{
    [primaryMetricColumn.id]: null
  }]).slice(0, 1);

  // TODO: optimize this so it doesn't run many times
  const metricConfigs = (breakdownByColumn ? data.rows : firstRowForNonBreakdown).map((row, rowIdx) => {
    var _config$metric$palett, _getColor, _breakdownByColumn, _config$metric$color, _config$metric3, _config$metric4;
    const value = row[primaryMetricColumn.id] !== null ? row[primaryMetricColumn.id] : NaN;
    const title = breakdownByColumn ? formatBreakdownValue(row[breakdownByColumn.id]) : primaryMetricColumn.name;
    const subtitle = breakdownByColumn ? primaryMetricColumn.name : config.metric.subtitle;
    const tileColor = (_config$metric$palett = config.metric.palette) !== null && _config$metric$palett !== void 0 && _config$metric$palett.params && typeof value === 'number' ? (_getColor = (0, _helpers.getColor)(value, config.metric.palette, {
      metric: primaryMetricColumn.id,
      max: maxColId,
      breakdownBy: (_breakdownByColumn = breakdownByColumn) === null || _breakdownByColumn === void 0 ? void 0 : _breakdownByColumn.id
    }, data, rowIdx)) !== null && _getColor !== void 0 ? _getColor : defaultColor : (_config$metric$color = config.metric.color) !== null && _config$metric$color !== void 0 ? _config$metric$color : defaultColor;
    let secondaryMetricProps;
    const {
      secondaryMetric
    } = config.dimensions;
    if (secondaryMetric) {
      // Do not call getSecondaryMetricInfo if there is no Secondary Metric
      const secondaryMetricInfo = (0, _secondary_metric_info.getSecondaryMetricInfo)({
        row,
        columns: data.columns,
        secondaryMetric,
        secondaryLabel: config.metric.secondaryLabel,
        trendConfig: buildTrendConfig(config.metric.secondaryTrend, value),
        staticColor: config.metric.secondaryColor
      });
      secondaryMetricProps = {
        value: secondaryMetricInfo.value,
        label: secondaryMetricInfo.label,
        badgeColor: secondaryMetricInfo.badgeColor,
        ariaDescription: secondaryMetricInfo.description,
        icon: secondaryMetricInfo.icon,
        labelPosition: config.metric.secondaryLabelPosition,
        badgeBorderColor: highContrastMode ? {
          mode: 'auto'
        } : {
          mode: 'none'
        }
      };
    }
    if (typeof value !== 'number') {
      var _config$metric, _config$metric2, _config$metric$color2;
      const nonNumericMetricBase = {
        title: String(title),
        subtitle,
        icon: (_config$metric = config.metric) !== null && _config$metric !== void 0 && _config$metric.icon ? getIcon((_config$metric2 = config.metric) === null || _config$metric2 === void 0 ? void 0 : _config$metric2.icon) : undefined,
        extra: secondaryMetricProps,
        color: (_config$metric$color2 = config.metric.color) !== null && _config$metric$color2 !== void 0 ? _config$metric$color2 : defaultColor
      };
      return Array.isArray(value) ? {
        ...nonNumericMetricBase,
        value: value.map(v => formatPrimaryMetric(v))
      } : {
        ...nonNumericMetricBase,
        value: formatPrimaryMetric(value)
      };
    }
    const baseMetric = {
      value,
      valueFormatter: formatPrimaryMetric,
      title: String(title),
      subtitle,
      icon: (_config$metric3 = config.metric) !== null && _config$metric3 !== void 0 && _config$metric3.icon ? getIcon((_config$metric4 = config.metric) === null || _config$metric4 === void 0 ? void 0 : _config$metric4.icon) : undefined,
      extra: secondaryMetricProps,
      color: tileColor
    };
    const trendId = breakdownByColumn ? row[breakdownByColumn.id] : _constants.DEFAULT_TRENDLINE_NAME;
    if (config.metric.trends && config.metric.trends[trendId]) {
      const metricWTrend = {
        ...baseMetric,
        trend: config.metric.trends[trendId],
        trendShape: 'area',
        trendA11yTitle: _i18n.i18n.translate('expressionMetricVis.trendA11yTitle', {
          defaultMessage: '{dataTitle} over time.',
          values: {
            dataTitle: primaryMetricColumn.name
          }
        }),
        trendA11yDescription: _i18n.i18n.translate('expressionMetricVis.trendA11yDescription', {
          defaultMessage: 'A line chart showing the trend of the primary metric over time.'
        })
      };
      return metricWTrend;
    }
    if (maxColId && config.metric.progressDirection) {
      const metricWProgress = {
        ...baseMetric,
        domainMax: row[maxColId],
        progressBarDirection: config.metric.progressDirection
      };
      return metricWProgress;
    }

    // Metric with number, without trend line and without progress bar
    return {
      ...baseMetric,
      // Override the background and main value color when the color is applied to the value
      ...(config.metric.applyColorTo === 'value' ? {
        color: defaultColor,
        valueColor: tileColor
      } : {
        color: tileColor,
        valueColor: undefined
      })
    };
  });
  if (config.metric.minTiles) {
    while (metricConfigs.length < config.metric.minTiles) {
      metricConfigs.push(undefined);
    }
  }
  const {
    metric: {
      maxCols
    }
  } = config;
  const numRows = metricConfigs.length / maxCols;
  const minHeight = chartBaseTheme.metric.minHeight;

  // this needs to use a useEffect as it depends on the scrollContainerRef
  // which is not available on the first render
  (0, _react.useEffect)(() => {
    var _scrollDimensions$hei;
    const minimumRequiredVerticalSpace = minHeight * numRows;
    setScrollChildHeight(((_scrollDimensions$hei = scrollDimensions.height) !== null && _scrollDimensions$hei !== void 0 ? _scrollDimensions$hei : -Infinity) > minimumRequiredVerticalSpace ? '100%' : `${minimumRequiredVerticalSpace}px`);
  }, [numRows, minHeight, scrollDimensions.height]);
  const {
    theme: settingsThemeOverrides = {},
    ...settingsOverrides
  } = (0, _chartExpressionsCommon.getOverridesFor)(overrides, 'settings');
  const newGrid = [];
  for (let i = 0; i < metricConfigs.length; i += maxCols) {
    newGrid.push(metricConfigs.slice(i, i + maxCols));
  }
  grid.current = newGrid;
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: scrollContainerRef,
    css: [styles.layout, (0, _react2.css)`
          height: 100%;
          width: 100%;
          overflow-y: auto;
          ${(0, _eui.useEuiScrollBar)()}
        `],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          height: ${scrollChildHeight};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, (0, _extends2.default)({}, (0, _chartExpressionsCommon.getOverridesFor)(overrides, 'chart'), {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({
    onWillRender: onWillRender,
    locale: _i18n.i18n.getLocale(),
    theme: [{
      background: {
        color: defaultColor
      },
      metric: {
        barBackground: colors.lightestShade,
        emptyBackground: colors.emptyShade,
        blendingBackground: colors.emptyShade,
        titlesTextAlign: config.metric.titlesTextAlign,
        valueTextAlign: config.metric.primaryAlign,
        extraTextAlign: config.metric.secondaryAlign,
        iconAlign: config.metric.iconAlign,
        valueFontSize: config.metric.valueFontSize,
        valuePosition: config.metric.primaryPosition,
        titleWeight: config.metric.titleWeight
      }
    }, ...(Array.isArray(settingsThemeOverrides) ? settingsThemeOverrides : [settingsThemeOverrides])],
    baseTheme: chartBaseTheme,
    onRenderChange: onRenderChange,
    onElementClick: filterable ? events => {
      var _breakdownByColumn2;
      const colRef = (_breakdownByColumn2 = breakdownByColumn) !== null && _breakdownByColumn2 !== void 0 ? _breakdownByColumn2 : primaryMetricColumn;
      const rowLength = grid.current[0].length;
      events.forEach(event => {
        if ((0, _charts.isMetricElementEvent)(event)) {
          const colIdx = data.columns.findIndex(col => col === colRef);
          fireEvent(buildFilterEvent(event.rowIndex * rowLength + event.columnIndex, colIdx, data));
        }
      });
    } : undefined
  }, settingsOverrides, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Metric, {
    id: "metric",
    data: grid.current,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 377,
      columnNumber: 11
    }
  }))));
};
exports.MetricVis = MetricVis;
const styles = {
  layout: (0, _react2.css)({
    '.echMetricText__valuesBlock': {
      display: 'flex',
      minWidth: 0,
      maxWidth: '100%'
    },
    '.echMetricText__valuesBlock > div': {
      minWidth: 'inherit',
      maxWidth: 'inherit'
    }
  })
};