/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
lexer grammar Project;

//
// DROP, KEEP
//
DROP : 'drop'                 -> pushMode(PROJECT_MODE);
KEEP : 'keep'                 -> pushMode(PROJECT_MODE);
DEV_INSIST :      {this.isDevVersion()}? 'insist_🐔'      -> pushMode(PROJECT_MODE);

mode PROJECT_MODE;
PROJECT_PIPE : PIPE -> type(PIPE), popMode;
// explicit popMode of RP to allow DROP and KEEP in FORK branches
PROJECT_RP : RP -> type(RP), popMode, popMode;
PROJECT_DOT: DOT -> type(DOT);
PROJECT_OPENING_BRACKET : OPENING_BRACKET -> type(OPENING_BRACKET);
PROJECT_CLOSING_BRACKET : CLOSING_BRACKET -> type(CLOSING_BRACKET);
PROJECT_COMMA : COMMA -> type(COMMA);
PROJECT_PARAM : PARAM -> type(PARAM);
PROJECT_NAMED_OR_POSITIONAL_PARAM : NAMED_OR_POSITIONAL_PARAM -> type(NAMED_OR_POSITIONAL_PARAM);
PROJECT_DOUBLE_PARAMS : DOUBLE_PARAMS -> type(DOUBLE_PARAMS);
PROJECT_NAMED_OR_POSITIONAL_DOUBLE_PARAMS : NAMED_OR_POSITIONAL_DOUBLE_PARAMS -> type(NAMED_OR_POSITIONAL_DOUBLE_PARAMS);

fragment UNQUOTED_ID_BODY_WITH_PATTERN
    : (LETTER | DIGIT | UNDERSCORE | ASTERISK)
    ;

fragment UNQUOTED_ID_PATTERN
    : (LETTER | ASTERISK) UNQUOTED_ID_BODY_WITH_PATTERN*
    | (UNDERSCORE | ASPERAND) UNQUOTED_ID_BODY_WITH_PATTERN+
    ;

ID_PATTERN
    : (UNQUOTED_ID_PATTERN | QUOTED_ID)+
    ;

PROJECT_LINE_COMMENT
    : LINE_COMMENT -> channel(HIDDEN)
    ;

PROJECT_MULTILINE_COMMENT
    : MULTILINE_COMMENT -> channel(HIDDEN)
    ;

PROJECT_WS
    : WS -> channel(HIDDEN)
    ;
