"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicData = DynamicData;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _components = require("../../../components");
var _helpers = require("../../../helpers");
var _hooks = require("../../hooks");
var _form_context = require("../../form_context");
var _use_field = require("../use_field");
var _use_array = require("../use_array");
var _form_utils = require("./form_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/static/forms/hook_form_lib/components/__stories__/use_array_dynamic_data.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  emptyField
} = _helpers.fieldValidators;

// Select field options
const ruleTypeOptions = [{
  value: 'type_one',
  text: 'Type one'
}, {
  value: 'type_two',
  text: 'Type two'
}];
const processorTypeOptions = [{
  value: 'percentage',
  text: 'Percentage'
}, {
  value: 'value',
  text: 'Value'
}];
const percentageOptions = [{
  value: 'percentage_config_1',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }, "Percentage 1")
}, {
  value: 'percentage_config_2',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, "Percentage 2")
}, {
  value: 'percentage_config_3',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }, "Percentage 3")
}];
const valueOptions = [{
  value: 'value_config_1',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "subdued",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, "Value 1")
}, {
  value: 'value_config_2',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "warning",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, "Value 2")
}, {
  value: 'value_config_3',
  inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "danger",
    css: {
      lineHeight: 'inherit'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, "Value 3")
}];

// Dynamic data that we will be loaded in the form when selecting the rule "type one"
const processorsTypeOne = [{
  name: 'DynamicTypeOne1',
  type: 'value',
  config: 'value_config_2'
}, {
  name: 'DynamicTypeOne2',
  type: 'value',
  config: 'value_config_3'
}, {
  name: 'DynamicTypeOne3',
  type: 'percentage',
  config: 'percentage_config_2'
}];

// Dynamic data that we will be loaded in the form when selecting the rule "type two"
const processorsTypeTwo = [{
  name: 'DynamicTypeTwo1',
  type: 'percentage',
  config: 'percentage_config_2'
}, {
  name: 'DynamicTypeTwo2',
  type: 'value',
  config: 'value_config_3'
}];

// Form field configs
const processorConfig = {
  label: 'Config'
};
const percentageProcessorTypeConfig = {
  label: 'Processor type',
  defaultValue: 'percentage'
};
const ProcessorTypeConfigurator = ({
  basePath,
  readDefaultValueOnForm
}) => {
  const {
    getFields
  } = (0, _form_context.useFormContext)();
  const processorTypePath = `${basePath}.type`;
  const processorConfigPath = `${basePath}.config`;
  const [formData] = (0, _hooks.useFormData)({
    watch: [processorTypePath]
  });
  const processorType = (0, _lodash.get)(formData, processorTypePath);
  const options = processorType === 'percentage' ? percentageOptions : valueOptions;
  const defaultOption = options[0].value;
  const onProcessorTypeChange = newType => {
    const configSelectField = getFields()[processorConfigPath];

    // Set the first select option from the list
    configSelectField.setValue((newType === 'percentage' ? percentageOptions : valueOptions)[0].value);
  };
  const renderSelect = (0, _react.useCallback)(() => {
    if (!processorType) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
      path: processorConfigPath,
      component: _components.SuperSelectField,
      config: {
        ...processorConfig,
        defaultValue: defaultOption
      },
      componentProps: {
        euiFieldProps: {
          options
        }
      },
      readDefaultValueOnForm: readDefaultValueOnForm,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 170,
        columnNumber: 7
      }
    });
  }, [processorType, processorConfigPath, readDefaultValueOnForm, options, defaultOption]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: processorTypePath,
    config: percentageProcessorTypeConfig,
    component: _components.SelectField,
    componentProps: {
      euiFieldProps: {
        options: processorTypeOptions
      }
    },
    onChange: onProcessorTypeChange,
    readDefaultValueOnForm: readDefaultValueOnForm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 7
    }
  }, renderSelect()));
};
const processorNameConfig = {
  label: 'Name',
  validations: [{
    validator: emptyField('A name is required.')
  }]
};
const ProcessorsConfigurator = ({
  ruleType
}) => {
  return /*#__PURE__*/_react.default.createElement(_use_array.UseArray, {
    path: "processors",
    initialNumberOfItems: ruleType === 'type_one' ? 1 : 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 5
    }
  }, ({
    items,
    addItem,
    removeItem
  }) => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map(({
      id,
      path,
      isNew
    }) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        key: id,
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 218,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
        path: `${path}.name`,
        config: processorNameConfig,
        component: _components.TextField,
        componentProps: {
          euiFieldProps: {
            css: {
              maxWidth: '180px'
            }
          }
        },
        readDefaultValueOnForm: !isNew,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 221,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 235,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(ProcessorTypeConfigurator, {
        basePath: path,
        readDefaultValueOnForm: !isNew,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 237,
          columnNumber: 21
        }
      })), items.length > 1 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 240,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "minusInCircle",
        onClick: () => removeItem(id),
        "aria-label": "Remove processor",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 241,
          columnNumber: 23
        }
      })));
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 251,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 254,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: addItem,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 255,
        columnNumber: 15
      }
    }, "Add processor")));
  });
};
const FormContent = () => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    updateFieldValues
  } = (0, _form_context.useFormContext)();
  const [{
    ruleType
  }] = (0, _hooks.useFormData)({
    watch: 'ruleType'
  });
  const onRuleTypeChange = (0, _react.useCallback)(updatedRuleType => {
    if (!updatedRuleType) {
      return;
    }
    setIsLoading(true);

    // Simulate HTTP latency
    setTimeout(() => {
      updateFieldValues({
        // Set dynamically the processors based on the "ruleType" selected.
        // In a real world scenario this would probably occur after fetching data on the server
        processors: updatedRuleType === 'type_one' ? processorsTypeOne : processorsTypeTwo
      });
      setIsLoading(false);
    }, 500);
  }, [updateFieldValues]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 9
    }
  }, "Rule configurator")), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_use_field.UseField, {
    path: "ruleType",
    component: _components.SelectField,
    onChange: onRuleTypeChange,
    componentProps: {
      euiFieldProps: {
        options: ruleTypeOptions
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 311,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 13
    }
  }, "Processors"))), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 7
    }
  }), ruleType !== undefined && /*#__PURE__*/_react.default.createElement(ProcessorsConfigurator, {
    ruleType: ruleType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 34
    }
  }));
};
/**
 * Form defaultValue - Loaded from backend
 */
const defaultValue = {
  ruleType: 'type_two',
  processors: [{
    name: 'TypeTwoName1',
    type: 'value',
    config: 'value_config_3'
  }, {
    name: 'TypeTwoName2',
    type: 'percentage',
    config: 'percentage_config_2'
  }]
};

/** Form schema */
const schema = {
  ruleType: {
    label: 'Rule type',
    helpText: 'Change the rule type to load other processor configurations',
    defaultValue: 'type_one'
  }
};
const formConfig = {
  schema,
  defaultValue
};
function DynamicData() {
  return /*#__PURE__*/_react.default.createElement(_form_utils.FormWrapper, {
    formConfig: formConfig,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 361,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FormContent, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 7
    }
  }));
}
DynamicData.storyName = 'Dynamic data';
DynamicData.parameters = {
  docs: {
    source: {
      code: `
// Select field options
const ruleTypeOptions = [
  { value: 'type_one', text: 'Type one' },
  { value: 'type_two', text: 'Type two' },
];

const processorTypeOptions = [
  { value: 'percentage', text: 'Percentage' },
  { value: 'value', text: 'Value' },
];

const percentageOptions = [
  {
    value: 'percentage_config_1',
    inputDisplay: (
      <EuiHealth color="subdued" css={{ lineHeight: 'inherit' }}>
        Percentage 1
      </EuiHealth>
    ),
  },
  {
    value: 'percentage_config_2',
    inputDisplay: (
      <EuiHealth color="warning" css={{ lineHeight: 'inherit' }}>
        Percentage 2
      </EuiHealth>
    ),
  },
  {
    value: 'percentage_config_3',
    inputDisplay: (
      <EuiHealth color="danger" css={{ lineHeight: 'inherit' }}>
        Percentage 3
      </EuiHealth>
    ),
  },
];

const valueOptions = [
  {
    value: 'value_config_1',
    inputDisplay: (
      <EuiHealth color="subdued" css={{ lineHeight: 'inherit' }}>
        Value 1
      </EuiHealth>
    ),
  },
  {
    value: 'value_config_2',
    inputDisplay: (
      <EuiHealth color="warning" css={{ lineHeight: 'inherit' }}>
        Value 2
      </EuiHealth>
    ),
  },
  {
    value: 'value_config_3',
    inputDisplay: (
      <EuiHealth color="danger" css={{ lineHeight: 'inherit' }}>
        Value 3
      </EuiHealth>
    ),
  },
];

// Dynamic data that we will be loaded in the form when selecting the rule "type one"
const processorsTypeOne = [
  {
    name: 'DynamicTypeOne1',
    type: 'value',
    config: 'value_config_2',
  },
  {
    name: 'DynamicTypeOne2',
    type: 'value',
    config: 'value_config_3',
  },
  {
    name: 'DynamicTypeOne3',
    type: 'percentage',
    config: 'percentage_config_2',
  },
];

// Dynamic data that we will be loaded in the form when selecting the rule "type two"
const processorsTypeTwo = [
  {
    name: 'DynamicTypeTwo1',
    type: 'percentage',
    config: 'percentage_config_2',
  },
  {
    name: 'DynamicTypeTwo2',
    type: 'value',
    config: 'value_config_3',
  },
];

// Form field configs
const processorConfig = { label: 'Config' };
const percentageProcessorTypeConfig = { label: 'Processor type', defaultValue: 'percentage' };

const ProcessorTypeConfigurator = ({
  basePath,
  readDefaultValueOnForm,
}: {
  basePath: string;
  readDefaultValueOnForm: boolean;
}) => {
  const { getFields } = useFormContext();
  const processorTypePath = \`\${basePath}.type\`;
  const processorConfigPath = \`\${basePath}.config\`;
  const [formData] = useFormData({
    watch: [processorTypePath],
  });

  const processorType = get(formData, processorTypePath);
  const options = processorType === 'percentage' ? percentageOptions : valueOptions;
  const defaultOption = options[0].value;

  const onProcessorTypeChange = (newType: string) => {
    const configSelectField = getFields()[processorConfigPath];

    // Set the first select option from the list
    configSelectField.setValue(
      (newType === 'percentage' ? percentageOptions : valueOptions)[0].value
    );
  };

  const renderSelect = useCallback(() => {
    if (!processorType) {
      return null;
    }

    return (
      <UseField
        path={processorConfigPath}
        component={SuperSelectField}
        config={{ ...processorConfig, defaultValue: defaultOption }}
        componentProps={{
          euiFieldProps: {
            options,
          },
        }}
        readDefaultValueOnForm={readDefaultValueOnForm}
      />
    );
  }, [processorType, processorConfigPath, readDefaultValueOnForm, options, defaultOption]);

  return (
    <EuiFlexGroup>
      <EuiFlexItem>
        <UseField
          path={processorTypePath}
          config={percentageProcessorTypeConfig}
          component={SelectField}
          componentProps={{
            euiFieldProps: {
              options: processorTypeOptions,
            },
          }}
          onChange={onProcessorTypeChange}
          readDefaultValueOnForm={readDefaultValueOnForm}
        />
      </EuiFlexItem>
      <EuiFlexItem>{renderSelect()}</EuiFlexItem>
    </EuiFlexGroup>
  );
};

const processorNameConfig = {
  label: 'Name',
  validations: [{ validator: emptyField('A name is required.') }],
};

const ProcessorsConfigurator: FC<{ ruleType: string }> = ({ ruleType }) => {
  return (
    <UseArray path="processors" initialNumberOfItems={ruleType === 'type_one' ? 1 : 3}>
      {({ items, addItem, removeItem }) => {
        return (
          <>
            {items.map(({ id, path, isNew }) => {
              return (
                <EuiFlexGroup key={id} alignItems="center">
                  <EuiFlexItem grow={false}>
                    {/* Processor name */}
                    <UseField
                      path={\`\${path}.name\`}
                      config={processorNameConfig}
                      component={TextField}
                      componentProps={{
                        euiFieldProps: {
                          css: {
                            maxWidth: '180px',
                          },
                        },
                      }}
                      readDefaultValueOnForm={!isNew}
                    />
                  </EuiFlexItem>
                  <EuiFlexItem>
                    {/* Processor type & config */}
                    <ProcessorTypeConfigurator basePath={path} readDefaultValueOnForm={!isNew} />
                  </EuiFlexItem>
                  {items.length > 1 && (
                    <EuiFlexItem grow={false}>
                      <EuiButtonIcon
                        iconType="minusInCircle"
                        onClick={() => removeItem(id)}
                        aria-label="Remove processor"
                      />
                    </EuiFlexItem>
                  )}
                </EuiFlexGroup>
              );
            })}
            <EuiSpacer size="m" />

            {/* Add processor button */}
            <EuiFlexGroup justifyContent="flexEnd">
              <EuiButtonEmpty onClick={addItem}>Add processor</EuiButtonEmpty>
            </EuiFlexGroup>
          </>
        );
      }}
    </UseArray>
  );
};

interface MyForm {
  ruleType: string;
  processors: Array<{ name: string; type: string; config: string }>;
}

/**
 * Form defaultValue - Loaded from backend
 */
const defaultValue = {
  ruleType: 'type_two',
  processors: [
    { name: 'TypeTwoName1', type: 'value', config: 'value_config_3' },
    { name: 'TypeTwoName2', type: 'percentage', config: 'percentage_config_2' },
  ],
};

/** Form schema */
const schema = {
  ruleType: {
    label: 'Rule type',
    helpText: 'Change the rule type to load other processor configurations',
    defaultValue: 'type_one',
  },
};

const MyFormComponent = () => {
  const { form } = useForm({ schema, defaultValue });

  const [isLoading, setIsLoading] = useState(false);
  const { updateFieldValues } = form;
  const [{ ruleType }] = useFormData({ form, watch: 'ruleType' });

  const onRuleTypeChange = useCallback(
    (updatedRuleType: string) => {
      if (!updatedRuleType) {
        return;
      }

      setIsLoading(true);

      // Simulate HTTP latency
      setTimeout(() => {
        updateFieldValues({
          // Set dynamically the processors based on the "ruleType" selected.
          // In a real world scenario this would probably occur after fetching data on the server
          processors: updatedRuleType === 'type_one' ? processorsTypeOne : processorsTypeTwo,
        });

        setIsLoading(false);
      }, 500);
    },
    [updateFieldValues]
  );

  const submitForm = async () => {
    const { isValid, data } = await form.submit();
    if (isValid) {
      // ... do something with the data
    }
  };

  return (
    <Form form={form}>
      <EuiTitle>
        <h2>Rule configurator</h2>
      </EuiTitle>
      <EuiSpacer size="xl" />

      {/* Rule type */}
      <UseField
        path="ruleType"
        component={SelectField}
        onChange={onRuleTypeChange}
        componentProps={{
          euiFieldProps: {
            options: ruleTypeOptions,
          },
        }}
      />
      <EuiSpacer />

      <EuiFlexGroup gutterSize="s" alignItems="center">
        <EuiFlexItem grow={false}>
          <EuiTitle size="s">
            <h2>Processors</h2>
          </EuiTitle>
        </EuiFlexItem>
        {isLoading && (
          <EuiFlexItem grow={false}>
            <EuiLoadingSpinner size="m" />
          </EuiFlexItem>
        )}
      </EuiFlexGroup>
      <EuiSpacer size="s" />
      {ruleType !== undefined && <ProcessorsConfigurator ruleType={ruleType} />}
      <EuiSpacer />
      <EuiButton onClick={submitForm}>Send</EuiButton>
    </Form>
  );
}
      `,
      language: 'tsx'
    }
  }
};