"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilteringRulesTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/shared/filtering_rules_table/filtering_rules_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FilteringRulesTable = ({
  showOrder,
  filteringRules
}) => {
  const columns = [...(showOrder ? [{
    field: 'order',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.filtering.priority', {
      defaultMessage: 'Rule priority'
    })
  }] : []), {
    field: 'policy',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.filtering.policy', {
      defaultMessage: 'Policy'
    }),
    render: policy => (0, _searchConnectors.filteringPolicyToText)(policy)
  }, {
    field: 'field',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.filtering.field', {
      defaultMessage: 'field'
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 34
      }
    }, value)
  }, {
    field: 'rule',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.filtering.rule', {
      defaultMessage: 'Rule'
    }),
    render: rule => (0, _searchConnectors.filteringRuleToText)(rule)
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.index.filtering.value', {
      defaultMessage: 'Value'
    }),
    render: value => /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 34
      }
    }, value)
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: filteringRules.sort(({
      order
    }, {
      order: secondOrder
    }) => order - secondOrder),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 5
    }
  });
};
exports.FilteringRulesTable = FilteringRulesTable;