"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConvertConnectorModal = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
var _convert_connector_logic = require("../../search_index/connector/native_connector_configuration/convert_connector_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/shared/convert_connector_modal/convert_connector_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConvertConnectorModal = () => {
  const {
    convertConnector,
    hideModal
  } = (0, _kea.useActions)(_convert_connector_logic.ConvertConnectorLogic);
  const {
    isLoading
  } = (0, _kea.useValues)(_convert_connector_logic.ConvertConnectorLogic);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.convertInfexConfirm.title', {
      defaultMessage: 'Sure you want to convert your connector?'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => hideModal(),
    onConfirm: () => convertConnector(),
    buttonColor: "danger",
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.convertIndexConfirm.text', {
      defaultMessage: 'Yes'
    }),
    isLoading: isLoading,
    defaultFocusedButton: "confirm",
    maxWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 26,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.convertIndexConfirm.description', {
    defaultMessage: "Converting an Elastic managed connector to a self-managed connector can't be undone."
  }))));
};
exports.ConvertConnectorModal = ConvertConnectorModal;