"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddInferencePipelineHorizontalSteps = exports.AddInferencePipelineFooter = exports.AddInferencePipelineFlyout = exports.AddInferencePipelineContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../shared/constants");
var _index_name_logic = require("../../index_name_logic");
var _index_view_logic = require("../../index_view_logic");
var _configure_fields = require("./configure_fields");
var _configure_pipeline = require("./configure_pipeline");
var _ml_inference_logic = require("./ml_inference_logic");
var _review_pipeline = require("./review_pipeline");
var Styles = _interopRequireWildcard(require("./styles"));
var _test_pipeline = require("./test_pipeline");
var _types = require("./types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ml_inference/add_inference_pipeline_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddInferencePipelineFlyout = props => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    setIndexName,
    makeMlInferencePipelinesRequest,
    startPollingModels,
    makeMappingRequest
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);
  (0, _react.useEffect)(() => {
    setIndexName(indexName);

    // Trigger fetching of initial data: existing ML pipelines, available models, index mapping
    makeMlInferencePipelinesRequest(undefined);
    startPollingModels();
    makeMappingRequest({
      indexName
    });
  }, [indexName]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: props.onClose,
    css: Styles.enterpriseSearchInferencePipelineFlyoutStyles(euiTheme),
    size: "l",
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.title', {
    defaultMessage: 'Add an inference pipeline'
  })))), /*#__PURE__*/_react.default.createElement(AddInferencePipelineContent, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 7
    }
  })));
};
exports.AddInferencePipelineFlyout = AddInferencePipelineFlyout;
const AddInferencePipelineContent = ({
  onClose
}) => {
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    createErrors,
    isLoading,
    addInferencePipelineModal: {
      step
    }
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);

  // Using the value of create errors to reduce unnecessary hook calls
  const createErrorsHookDep = createErrors.join('|');
  (0, _react.useEffect)(() => {
    if (createErrors.length === 0) return;
    const flyoutOverflow = document.getElementsByClassName('euiFlyoutBody__overflow');
    if (flyoutOverflow.length === 0) return;
    flyoutOverflow[0].scrollTop = 0;
  }, [createErrorsHookDep]);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 7
    }
  }, createErrors.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.createErrors', {
      defaultMessage: 'Error creating pipeline'
    }),
    color: "danger",
    iconType: "error",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }, createErrors.map((message, i) => /*#__PURE__*/_react.default.createElement("p", {
    key: `createError.${i}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  }, message))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(AddInferencePipelineHorizontalSteps, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), step === _types.AddInferencePipelineSteps.Configuration && /*#__PURE__*/_react.default.createElement(_configure_pipeline.ConfigurePipeline, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 62
    }
  }), step === _types.AddInferencePipelineSteps.Fields && /*#__PURE__*/_react.default.createElement(_configure_fields.ConfigureFields, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 55
    }
  }), step === _types.AddInferencePipelineSteps.Test && /*#__PURE__*/_react.default.createElement(_test_pipeline.TestPipeline, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 53
    }
  }), step === _types.AddInferencePipelineSteps.Review && /*#__PURE__*/_react.default.createElement(_review_pipeline.ReviewPipeline, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 55
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "enterpriseSearchInferencePipelineFlyoutFooter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(AddInferencePipelineFooter, {
    onClose: onClose,
    ingestionMethod: ingestionMethod,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  })));
};
exports.AddInferencePipelineContent = AddInferencePipelineContent;
const AddInferencePipelineHorizontalSteps = () => {
  const {
    addInferencePipelineModal: {
      step
    },
    isConfigureStepValid,
    isPipelineDataValid
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  const {
    onAddInferencePipelineStepChange
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);

  /**
   * Convenience function for determining the status of a step in the horizontal nav.
   * @param currentStep The current step in the pipeline.
   * @param otherStep The step to compare against.
   * @returns The status of the step.
   */
  const getStepStatus = (currentStep, otherStep) => currentStep > otherStep ? 'complete' : currentStep === otherStep ? 'current' : 'incomplete';
  const navSteps = [{
    // Configure
    onClick: () => onAddInferencePipelineStepChange(_types.AddInferencePipelineSteps.Configuration),
    status: step > _types.AddInferencePipelineSteps.Configuration ? 'complete' : 'current',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.steps.configure.title', {
      defaultMessage: 'Configure'
    })
  }, {
    // Fields
    onClick: () => {
      if (!isConfigureStepValid) return;
      onAddInferencePipelineStepChange(_types.AddInferencePipelineSteps.Fields);
    },
    status: isConfigureStepValid ? getStepStatus(step, _types.AddInferencePipelineSteps.Fields) : 'disabled',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.steps.fields.title', {
      defaultMessage: 'Fields'
    })
  }, {
    // Test
    onClick: () => {
      if (!isPipelineDataValid) return;
      onAddInferencePipelineStepChange(_types.AddInferencePipelineSteps.Test);
    },
    status: isPipelineDataValid ? getStepStatus(step, _types.AddInferencePipelineSteps.Test) : 'disabled',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.steps.test.title', {
      defaultMessage: 'Test (Optional)'
    })
  }, {
    // Review
    onClick: () => {
      if (!isPipelineDataValid) return;
      onAddInferencePipelineStepChange(_types.AddInferencePipelineSteps.Review);
    },
    status: isPipelineDataValid ? getStepStatus(step, _types.AddInferencePipelineSteps.Review) : 'disabled',
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.steps.review.title', {
      defaultMessage: 'Review'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiStepsHorizontal, {
    steps: navSteps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 10
    }
  });
};
exports.AddInferencePipelineHorizontalSteps = AddInferencePipelineHorizontalSteps;
const AddInferencePipelineFooter = ({
  ingestionMethod,
  onClose
}) => {
  const {
    addInferencePipelineModal: modal,
    isPipelineDataValid,
    isConfigureStepValid
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  const {
    attachPipeline,
    createPipeline,
    onAddInferencePipelineStepChange
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);
  const attachExistingPipeline = Boolean(modal.configuration.existingPipeline);
  let nextStep;
  let previousStep;
  let isContinueButtonEnabled = false;
  switch (modal.step) {
    case _types.AddInferencePipelineSteps.Configuration:
      nextStep = _types.AddInferencePipelineSteps.Fields;
      isContinueButtonEnabled = isConfigureStepValid;
      break;
    case _types.AddInferencePipelineSteps.Fields:
      nextStep = _types.AddInferencePipelineSteps.Test;
      previousStep = _types.AddInferencePipelineSteps.Configuration;
      isContinueButtonEnabled = isPipelineDataValid;
      break;
    case _types.AddInferencePipelineSteps.Test:
      nextStep = _types.AddInferencePipelineSteps.Review;
      previousStep = _types.AddInferencePipelineSteps.Fields;
      isContinueButtonEnabled = true;
      break;
    case _types.AddInferencePipelineSteps.Review:
      previousStep = _types.AddInferencePipelineSteps.Test;
      isContinueButtonEnabled = true;
      break;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 274,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-addMlInference-cancel`,
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 276,
      columnNumber: 9
    }
  }, _constants.CANCEL_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 7
    }
  }, previousStep !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "both",
    iconType: "arrowLeft",
    onClick: () => onAddInferencePipelineStepChange(previousStep),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 11
    }
  }, _constants.BACK_BUTTON_LABEL) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 7
    }
  }, nextStep !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-addMlInference-continue`,
    iconType: "arrowRight",
    iconSide: "right",
    onClick: () => onAddInferencePipelineStepChange(nextStep),
    disabled: !isContinueButtonEnabled,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 11
    }
  }, _constants.CONTINUE_BUTTON_LABEL) : attachExistingPipeline ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-addMlInference-attach`,
    disabled: !isContinueButtonEnabled,
    fill: true,
    onClick: attachPipeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 310,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.footer.attach', {
    defaultMessage: 'Attach'
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "success",
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-addMlInference-create`,
    disabled: !isContinueButtonEnabled,
    fill: true,
    onClick: createPipeline,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.transforms.addInferencePipelineModal.footer.create', {
    defaultMessage: 'Create pipeline'
  }))));
};
exports.AddInferencePipelineFooter = AddInferencePipelineFooter;