"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverTopNavMenuProvider = exports.DiscoverTopNavMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/navigation-plugin/public");
var _rxjs = require("rxjs");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _css = require("@emotion/css");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/top_nav/discover_topnav_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * We handle the top nav menu this way because we need to render it higher in the tree than
 * individual tabs to avoid remounting when switching tabs, which leads to UI flickering,
 * but the menu items are dependent on individual tab state. This approach allows us to
 * update the menu items from lower in the tree without remounting the menu component itself.
 */

const createTopNavMenuContext = () => ({
  topNavMenu$: new _rxjs.BehaviorSubject(undefined),
  topNavBadges$: new _rxjs.BehaviorSubject(undefined)
});
const discoverTopNavMenuContext = /*#__PURE__*/(0, _react.createContext)(createTopNavMenuContext());

// If there are no menu items to render yet, we render a placeholder
// item to ensure the menu still displays and to prevent flickering
const PLACEHOLDER_MENU_ITEMS = [{
  label: '',
  run: () => {},
  className: (0, _css.css)({
    display: 'none'
  })
}];
const DiscoverTopNavMenuProvider = ({
  children
}) => {
  const {
    setHeaderActionMenu
  } = (0, _use_discover_services.useDiscoverServices)();
  const [topNavMenuContext] = (0, _react.useState)(() => createTopNavMenuContext());
  const topNavMenu = (0, _useObservable.default)(topNavMenuContext.topNavMenu$, topNavMenuContext.topNavMenu$.getValue());
  const topNavBadges = (0, _useObservable.default)(topNavMenuContext.topNavBadges$, topNavMenuContext.topNavBadges$.getValue());
  (0, _useUnmount.default)(() => {
    topNavMenuContext.topNavBadges$.next(undefined);
    topNavMenuContext.topNavMenu$.next(undefined);
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_public.TopNavMenu, {
    appName: "discover",
    badges: topNavBadges,
    config: topNavMenu && topNavMenu.length > 0 ? topNavMenu : PLACEHOLDER_MENU_ITEMS,
    gutterSize: "xxs",
    setMenuMountPoint: setHeaderActionMenu,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(discoverTopNavMenuContext.Provider, {
    value: topNavMenuContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, children));
};
exports.DiscoverTopNavMenuProvider = DiscoverTopNavMenuProvider;
const DiscoverTopNavMenu = ({
  topNavBadges,
  topNavMenu
}) => {
  const {
    topNavBadges$,
    topNavMenu$
  } = (0, _react.useContext)(discoverTopNavMenuContext);
  (0, _react.useLayoutEffect)(() => {
    topNavBadges$.next(topNavBadges);
  }, [topNavBadges, topNavBadges$]);
  (0, _react.useLayoutEffect)(() => {
    topNavMenu$.next(topNavMenu);
  }, [topNavMenu, topNavMenu$]);
  return null;
};
exports.DiscoverTopNavMenu = DiscoverTopNavMenu;