"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInspectAppMenuItem = void 0;
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getInspectAppMenuItem = ({
  onOpenInspector
}) => {
  return {
    id: _discoverUtils.AppMenuActionId.inspect,
    type: _discoverUtils.AppMenuActionType.secondary,
    controlProps: {
      label: _i18n.i18n.translate('discover.localMenu.inspectTitle', {
        defaultMessage: 'Inspect'
      }),
      description: _i18n.i18n.translate('discover.localMenu.openInspectorForSearchDescription', {
        defaultMessage: 'Open Inspector for search'
      }),
      testId: 'openInspectorButton',
      onClick: () => {
        onOpenInspector();
      }
    }
  };
};
exports.getInspectAppMenuItem = getInspectAppMenuItem;