"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PatternAnalysisTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _lodash = require("lodash");
var _use_discover_services = require("../../../../hooks/use_discover_services");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763726912090392696/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/pattern_analysis/pattern_analysis_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PatternAnalysisTable = props => {
  const [lastReloadRequestTime, setLastReloadRequestTime] = (0, _react.useState)(undefined);
  const services = (0, _use_discover_services.useDiscoverServices)();
  const aiopsService = services.aiops;
  const {
    trackUiMetric,
    stateContainer
  } = props;
  (0, _react.useEffect)(() => {
    const refetch = stateContainer === null || stateContainer === void 0 ? void 0 : stateContainer.dataState.refetch$.subscribe(() => {
      setLastReloadRequestTime(Date.now());
    });
    return () => {
      refetch === null || refetch === void 0 ? void 0 : refetch.unsubscribe();
    };
  }, [stateContainer]);
  (0, _react.useEffect)(() => {
    // Track should only be called once when component is loaded
    if (aiopsService) {
      trackUiMetric === null || trackUiMetric === void 0 ? void 0 : trackUiMetric(_analytics.METRIC_TYPE.LOADED, _constants.PATTERN_ANALYSIS_LOADED);
    }
  }, [aiopsService, trackUiMetric]);
  const patternAnalysisComponentProps = (0, _react.useMemo)(() => ({
    input: Object.assign({}, (0, _lodash.pick)(props, ['dataView', 'savedSearch', 'switchToDocumentView']), {
      lastReloadRequestTime
    }),
    renderViewModeToggle: props.renderViewModeToggle
  }), [lastReloadRequestTime, props]);
  if (!aiopsService) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(aiopsService.PatternAnalysisComponent, {
    props: patternAnalysisComponentProps,
    appContextValue:
    // TODO We shouldn't cast to `unknown` here, goal is to use feature specific contexts.
    // See https://github.com/elastic/kibana/pull/194442
    {
      embeddingOrigin: 'discover',
      ...services
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  });
};
exports.PatternAnalysisTable = PatternAnalysisTable;